/*
 * Decompiled with CFR 0.152.
 */
package wisp.security.ssl;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.TrustManagerFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import wisp.security.ssl.CertificateAndKey;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\u001a\u001f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\"\n\b\u0000\u0010\t\u0018\u0001*\u00020\n*\u00020\u0004H\u0086\b\u001a \u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b*\u00020\u00042\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\f\u001a\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u0012\u0010\u0012\u001a\u00020\u0013*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010\u001a\u001a\u0010\u0012\u001a\u00020\u0013*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0004\u001a\u0012\u0010\u0014\u001a\u00020\u0015*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0001\u001a\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017*\u00020\u0004\u00a2\u0006\u0002\u0010\u0018\u001a\u001d\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0017*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0019\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\u0003\u001a\u00020\u0001*\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"trustAlgorithm", "", "kotlin.jvm.PlatformType", "onlyAlias", "Ljava/security/KeyStore;", "getOnlyAlias", "(Ljava/security/KeyStore;)Ljava/lang/String;", "aliasesOfType", "", "T", "Ljava/security/KeyStore$Entry;", "entryClass", "Ljava/lang/Class;", "getCertificateAndKey", "Lwisp/security/ssl/CertificateAndKey;", "passphrase", "", "alias", "getPrivateKey", "Ljava/security/PrivateKey;", "getX509Certificate", "Ljava/security/cert/X509Certificate;", "getX509CertificateChain", "", "(Ljava/security/KeyStore;)[Ljava/security/cert/X509Certificate;", "(Ljava/security/KeyStore;Ljava/lang/String;)[Ljava/security/cert/X509Certificate;", "wisp-ssl"})
@SourceDebugExtension(value={"SMAP\nKeystoreExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeystoreExtensions.kt\nwisp/security/ssl/KeystoreExtensionsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,93:1\n1#2:94\n1#2:105\n11383#3,9:95\n13309#3:104\n13310#3:106\n11392#3:107\n37#4,2:108\n*S KotlinDebug\n*F\n+ 1 KeystoreExtensions.kt\nwisp/security/ssl/KeystoreExtensionsKt\n*L\n72#1:105\n72#1:95,9\n72#1:104\n72#1:106\n72#1:107\n72#1:108,2\n*E\n"})
public final class KeystoreExtensionsKt {
    private static final String trustAlgorithm = TrustManagerFactory.getDefaultAlgorithm();

    @Nullable
    public static final CertificateAndKey getCertificateAndKey(@NotNull KeyStore $this$getCertificateAndKey, @NotNull String alias, @NotNull char[] passphrase) {
        Intrinsics.checkNotNullParameter((Object)$this$getCertificateAndKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        try {
            if (!$this$getCertificateAndKey.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                return null;
            }
            Certificate certificate = $this$getCertificateAndKey.getCertificate(alias);
            Intrinsics.checkNotNull((Object)certificate, (String)"null cannot be cast to non-null type java.security.cert.X509Certificate");
            X509Certificate certificate2 = (X509Certificate)certificate;
            Key key = $this$getCertificateAndKey.getKey(alias, passphrase);
            Intrinsics.checkNotNull((Object)key, (String)"null cannot be cast to non-null type java.security.PrivateKey");
            PrivateKey key2 = (PrivateKey)key;
            return new CertificateAndKey(certificate2, key2);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException("Did you forget to call KeyStore.load?", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException("KeyStore entry password incorrect.", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    @Nullable
    public static final CertificateAndKey getCertificateAndKey(@NotNull KeyStore $this$getCertificateAndKey, @NotNull char[] passphrase) {
        Intrinsics.checkNotNullParameter((Object)$this$getCertificateAndKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return KeystoreExtensionsKt.getCertificateAndKey($this$getCertificateAndKey, KeystoreExtensionsKt.getOnlyAlias($this$getCertificateAndKey), passphrase);
    }

    @NotNull
    public static final String getOnlyAlias(@NotNull KeyStore $this$onlyAlias) {
        Intrinsics.checkNotNullParameter((Object)$this$onlyAlias, (String)"<this>");
        Enumeration<String> aliases = $this$onlyAlias.aliases();
        String element = aliases.nextElement();
        if (!(element != null)) {
            boolean $i$a$-check-KeystoreExtensionsKt$onlyAlias$32 = false;
            String $i$a$-check-KeystoreExtensionsKt$onlyAlias$32 = "no alias found in keystore";
            throw new IllegalStateException($i$a$-check-KeystoreExtensionsKt$onlyAlias$32.toString());
        }
        if (!(!aliases.hasMoreElements())) {
            boolean bl = false;
            String string = "more than one alias in keystore ";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)element);
        return element;
    }

    @NotNull
    public static final PrivateKey getPrivateKey(@NotNull KeyStore $this$getPrivateKey, @NotNull String alias, @NotNull char[] passphrase) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrivateKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        try {
            Key key = $this$getPrivateKey.getKey(alias, passphrase);
            PrivateKey privateKey = key instanceof PrivateKey ? (PrivateKey)key : null;
            if (privateKey == null) {
                throw new IllegalStateException("no private key with alias " + alias);
            }
            return privateKey;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm for reading key not available", e);
        }
        catch (UnrecoverableKeyException e) {
            throw new IllegalArgumentException("Invalid password for reading key " + alias, e);
        }
    }

    @NotNull
    public static final PrivateKey getPrivateKey(@NotNull KeyStore $this$getPrivateKey, @NotNull char[] passphrase) {
        Intrinsics.checkNotNullParameter((Object)$this$getPrivateKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return KeystoreExtensionsKt.getPrivateKey($this$getPrivateKey, KeystoreExtensionsKt.getOnlyAlias($this$getPrivateKey), passphrase);
    }

    @NotNull
    public static final List<String> aliasesOfType(@NotNull KeyStore $this$aliasesOfType, @NotNull Class<? extends KeyStore.Entry> entryClass) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasesOfType, (String)"<this>");
        Intrinsics.checkNotNullParameter(entryClass, (String)"entryClass");
        Enumeration<String> enumeration = $this$aliasesOfType.aliases();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"aliases(...)");
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration)), (Function1)((Function1)new Function1<String, Boolean>($this$aliasesOfType, entryClass){
            final /* synthetic */ KeyStore $this_aliasesOfType;
            final /* synthetic */ Class<? extends KeyStore.Entry> $entryClass;
            {
                this.$this_aliasesOfType = $receiver;
                this.$entryClass = $entryClass;
                super(1);
            }

            @NotNull
            public final Boolean invoke(String it) {
                return this.$this_aliasesOfType.entryInstanceOf(it, this.$entryClass);
            }
        })));
    }

    public static final /* synthetic */ <T extends KeyStore.Entry> List<String> aliasesOfType(KeyStore $this$aliasesOfType) {
        Intrinsics.checkNotNullParameter((Object)$this$aliasesOfType, (String)"<this>");
        boolean $i$f$aliasesOfType = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return KeystoreExtensionsKt.aliasesOfType($this$aliasesOfType, KeyStore.Entry.class);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final X509Certificate[] getX509CertificateChain(@NotNull KeyStore $this$getX509CertificateChain, @NotNull String alias) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$getX509CertificateChain, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (!(!StringsKt.isBlank((CharSequence)alias))) {
            boolean $i$a$-require-KeystoreExtensionsKt$getX509CertificateChain$22 = false;
            String $i$a$-require-KeystoreExtensionsKt$getX509CertificateChain$22 = "alias must not be empty or blank";
            throw new IllegalArgumentException($i$a$-require-KeystoreExtensionsKt$getX509CertificateChain$22.toString());
        }
        Certificate[] certs = $this$getX509CertificateChain.getCertificateChain(alias);
        if (!(certs != null && !(certs.length == 0))) {
            boolean $i$a$-check-KeystoreExtensionsKt$getX509CertificateChain$32 = false;
            String $i$a$-check-KeystoreExtensionsKt$getX509CertificateChain$32 = "no certificate chain found for alias " + alias;
            throw new IllegalStateException($i$a$-check-KeystoreExtensionsKt$getX509CertificateChain$32.toString());
        }
        Intrinsics.checkNotNull((Object)certs);
        Certificate[] $this$mapNotNull$iv = certs;
        boolean $i$f$mapNotNull = false;
        Certificate[] certificateArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            X509Certificate it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if ((it instanceof X509Certificate ? (X509Certificate)it : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new X509Certificate[0]);
    }

    @NotNull
    public static final X509Certificate[] getX509CertificateChain(@NotNull KeyStore $this$getX509CertificateChain) {
        Intrinsics.checkNotNullParameter((Object)$this$getX509CertificateChain, (String)"<this>");
        return KeystoreExtensionsKt.getX509CertificateChain($this$getX509CertificateChain, KeystoreExtensionsKt.getOnlyAlias($this$getX509CertificateChain));
    }

    @NotNull
    public static final X509Certificate getX509Certificate(@NotNull KeyStore $this$getX509Certificate, @NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)$this$getX509Certificate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        if (!(!StringsKt.isBlank((CharSequence)alias))) {
            boolean bl = false;
            String string = "alias must not be empty or blank";
            throw new IllegalArgumentException(string.toString());
        }
        Certificate certificate = $this$getX509Certificate.getCertificate(alias);
        if (certificate == null) {
            throw new IllegalStateException("no certificate found for alias " + alias);
        }
        Certificate cert = certificate;
        X509Certificate x509Certificate = cert instanceof X509Certificate ? (X509Certificate)cert : null;
        if (x509Certificate == null) {
            throw new IllegalStateException("certificate for " + alias + " is not an X509 certificate");
        }
        return x509Certificate;
    }

    @NotNull
    public static final X509Certificate getX509Certificate(@NotNull KeyStore $this$getX509Certificate) {
        Intrinsics.checkNotNullParameter((Object)$this$getX509Certificate, (String)"<this>");
        return KeystoreExtensionsKt.getX509Certificate($this$getX509Certificate, KeystoreExtensionsKt.getOnlyAlias($this$getX509Certificate));
    }
}

