/*
 * Decompiled with CFR 0.152.
 */
package wisp.security.ssl;

import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509ExtendedKeyManager;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import wisp.security.ssl.KeystoreExtensionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\nJ-\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0013J5\u0010\u0014\u001a\u00020\f2\u000e\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a2\u0006\u0002\u0010\u0016J+\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\r\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00100\u000fH\u0016\u00a2\u0006\u0002\u0010\u0018J\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000f2\u0006\u0010\u001c\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lwisp/security/ssl/KeyStoreX509KeyManager;", "Ljavax/net/ssl/X509ExtendedKeyManager;", "passphrase", "", "lazyKeyStore", "Lkotlin/Function0;", "Ljava/security/KeyStore;", "<init>", "([CLkotlin/jvm/functions/Function0;)V", "keyStore", "([CLjava/security/KeyStore;)V", "chooseServerAlias", "", "keyType", "issuers", "", "Ljava/security/Principal;", "socket", "Ljava/net/Socket;", "(Ljava/lang/String;[Ljava/security/Principal;Ljava/net/Socket;)Ljava/lang/String;", "chooseClientAlias", "keyTypes", "([Ljava/lang/String;[Ljava/security/Principal;Ljava/net/Socket;)Ljava/lang/String;", "getClientAliases", "(Ljava/lang/String;[Ljava/security/Principal;)[Ljava/lang/String;", "getServerAliases", "getCertificateChain", "Ljava/security/cert/X509Certificate;", "alias", "(Ljava/lang/String;)[Ljava/security/cert/X509Certificate;", "getPrivateKey", "Ljava/security/PrivateKey;", "getPrivateKeyAlias", "wisp-ssl"})
@SourceDebugExtension(value={"SMAP\nKeyStoreX509KeyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyStoreX509KeyManager.kt\nwisp/security/ssl/KeyStoreX509KeyManager\n+ 2 KeystoreExtensions.kt\nwisp/security/ssl/KeystoreExtensionsKt\n*L\n1#1,54:1\n61#2:55\n*S KotlinDebug\n*F\n+ 1 KeyStoreX509KeyManager.kt\nwisp/security/ssl/KeyStoreX509KeyManager\n*L\n51#1:55\n*E\n"})
public final class KeyStoreX509KeyManager
extends X509ExtendedKeyManager {
    @NotNull
    private final char[] passphrase;
    @NotNull
    private final Function0<KeyStore> lazyKeyStore;

    public KeyStoreX509KeyManager(@NotNull char[] passphrase, @NotNull Function0<? extends KeyStore> lazyKeyStore) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter(lazyKeyStore, (String)"lazyKeyStore");
        this.passphrase = passphrase;
        this.lazyKeyStore = lazyKeyStore;
    }

    public KeyStoreX509KeyManager(@NotNull char[] passphrase, @NotNull KeyStore keyStore) {
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter((Object)keyStore, (String)"keyStore");
        this(passphrase, (Function0<? extends KeyStore>)((Function0)() -> KeyStoreX509KeyManager._init_$lambda$0(keyStore)));
    }

    @Override
    @NotNull
    public String chooseServerAlias(@NotNull String keyType, @NotNull Principal[] issuers, @NotNull Socket socket) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)issuers, (String)"issuers");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        return this.getPrivateKeyAlias();
    }

    @Override
    @NotNull
    public String chooseClientAlias(@NotNull String[] keyTypes, @NotNull Principal[] issuers, @NotNull Socket socket) {
        Intrinsics.checkNotNullParameter((Object)keyTypes, (String)"keyTypes");
        Intrinsics.checkNotNullParameter((Object)issuers, (String)"issuers");
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        return this.getPrivateKeyAlias();
    }

    @Override
    @NotNull
    public String[] getClientAliases(@NotNull String keyType, @NotNull Principal[] issuers) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)issuers, (String)"issuers");
        String[] stringArray = new String[]{this.getPrivateKeyAlias()};
        return stringArray;
    }

    @Override
    @NotNull
    public String[] getServerAliases(@NotNull String keyType, @NotNull Principal[] issuers) {
        Intrinsics.checkNotNullParameter((Object)keyType, (String)"keyType");
        Intrinsics.checkNotNullParameter((Object)issuers, (String)"issuers");
        String[] stringArray = new String[]{this.getPrivateKeyAlias()};
        return stringArray;
    }

    @Override
    @NotNull
    public X509Certificate[] getCertificateChain(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return KeystoreExtensionsKt.getX509CertificateChain((KeyStore)this.lazyKeyStore.invoke(), alias);
    }

    @Override
    @NotNull
    public PrivateKey getPrivateKey(@NotNull String alias) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        return KeystoreExtensionsKt.getPrivateKey((KeyStore)this.lazyKeyStore.invoke(), alias, this.passphrase);
    }

    private final String getPrivateKeyAlias() {
        KeyStore $this$aliasesOfType$iv = (KeyStore)this.lazyKeyStore.invoke();
        boolean $i$f$aliasesOfType = false;
        return (String)CollectionsKt.single(KeystoreExtensionsKt.aliasesOfType($this$aliasesOfType$iv, KeyStore.PrivateKeyEntry.class));
    }

    private static final KeyStore _init_$lambda$0(KeyStore $keyStore) {
        return $keyStore;
    }
}

