/*
 * Decompiled with CFR 0.152.
 */
package wisp.security.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.KeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\u00020\u0001:\u0001 B9\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003JC\u0010\u0019\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Lwisp/security/ssl/PemComboFile;", "", "certificates", "", "Lokio/ByteString;", "privateRsaKeys", "privateKeys", "passphrase", "", "<init>", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getCertificates", "()Ljava/util/List;", "getPrivateRsaKeys", "getPrivateKeys", "getPassphrase", "()Ljava/lang/String;", "newEmptyKeyStore", "Ljava/security/KeyStore;", "decodeCertificates", "Ljava/security/cert/Certificate;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "wisp-ssl"})
@SourceDebugExtension(value={"SMAP\nPemComboFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PemComboFile.kt\nwisp/security/ssl/PemComboFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,126:1\n1557#2:127\n1628#2,3:128\n*S KotlinDebug\n*F\n+ 1 PemComboFile.kt\nwisp/security/ssl/PemComboFile\n*L\n38#1:127\n38#1:128,3\n*E\n"})
public final class PemComboFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ByteString> certificates;
    @NotNull
    private final List<ByteString> privateRsaKeys;
    @NotNull
    private final List<ByteString> privateKeys;
    @NotNull
    private final String passphrase;

    public PemComboFile(@NotNull List<? extends ByteString> certificates, @NotNull List<? extends ByteString> privateRsaKeys, @NotNull List<? extends ByteString> privateKeys, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter(privateRsaKeys, (String)"privateRsaKeys");
        Intrinsics.checkNotNullParameter(privateKeys, (String)"privateKeys");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        this.certificates = certificates;
        this.privateRsaKeys = privateRsaKeys;
        this.privateKeys = privateKeys;
        this.passphrase = passphrase;
    }

    @NotNull
    public final List<ByteString> getCertificates() {
        return this.certificates;
    }

    @NotNull
    public final List<ByteString> getPrivateRsaKeys() {
        return this.privateRsaKeys;
    }

    @NotNull
    public final List<ByteString> getPrivateKeys() {
        return this.privateKeys;
    }

    @NotNull
    public final String getPassphrase() {
        return this.passphrase;
    }

    @NotNull
    public final KeyStore newEmptyKeyStore() {
        char[] cArray = this.passphrase.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] password = cArray;
        KeyStore result = KeyStore.getInstance(KeyStore.getDefaultType());
        result.load(null, password);
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Certificate> decodeCertificates() {
        void $this$mapTo$iv$iv;
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Iterable $this$map$iv = this.certificates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ByteString byteString = (ByteString)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(certificateFactory.generateCertificate(new Buffer().write((ByteString)it).inputStream()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ByteString> component1() {
        return this.certificates;
    }

    @NotNull
    public final List<ByteString> component2() {
        return this.privateRsaKeys;
    }

    @NotNull
    public final List<ByteString> component3() {
        return this.privateKeys;
    }

    @NotNull
    public final String component4() {
        return this.passphrase;
    }

    @NotNull
    public final PemComboFile copy(@NotNull List<? extends ByteString> certificates, @NotNull List<? extends ByteString> privateRsaKeys, @NotNull List<? extends ByteString> privateKeys, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter(certificates, (String)"certificates");
        Intrinsics.checkNotNullParameter(privateRsaKeys, (String)"privateRsaKeys");
        Intrinsics.checkNotNullParameter(privateKeys, (String)"privateKeys");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        return new PemComboFile(certificates, privateRsaKeys, privateKeys, passphrase);
    }

    public static /* synthetic */ PemComboFile copy$default(PemComboFile pemComboFile, List list, List list2, List list3, String string, int n, Object object) {
        if ((n & 1) != 0) {
            list = pemComboFile.certificates;
        }
        if ((n & 2) != 0) {
            list2 = pemComboFile.privateRsaKeys;
        }
        if ((n & 4) != 0) {
            list3 = pemComboFile.privateKeys;
        }
        if ((n & 8) != 0) {
            string = pemComboFile.passphrase;
        }
        return pemComboFile.copy(list, list2, list3, string);
    }

    @NotNull
    public String toString() {
        return "PemComboFile(certificates=" + this.certificates + ", privateRsaKeys=" + this.privateRsaKeys + ", privateKeys=" + this.privateKeys + ", passphrase=" + this.passphrase + ")";
    }

    public int hashCode() {
        int result = ((Object)this.certificates).hashCode();
        result = result * 31 + ((Object)this.privateRsaKeys).hashCode();
        result = result * 31 + ((Object)this.privateKeys).hashCode();
        result = result * 31 + this.passphrase.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PemComboFile)) {
            return false;
        }
        PemComboFile pemComboFile = (PemComboFile)other;
        if (!Intrinsics.areEqual(this.certificates, pemComboFile.certificates)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.privateRsaKeys, pemComboFile.privateRsaKeys)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.privateKeys, pemComboFile.privateKeys)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.passphrase, (Object)pemComboFile.passphrase);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000f*\u00020\u0007H\u0002J\u001e\u0010\u0010\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lwisp/security/ssl/PemComboFile$Companion;", "", "<init>", "()V", "parse", "Lwisp/security/ssl/PemComboFile;", "certKeyComboSource", "Lokio/BufferedSource;", "passphrase", "", "convertPKCS1toPKCS8", "Ljava/security/spec/KeySpec;", "pkcs1Key", "Lokio/ByteString;", "lines", "", "decodeBase64Until", "", "until", "Lkotlin/text/Regex;", "wisp-ssl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PemComboFile parse(@NotNull BufferedSource certKeyComboSource, @Nullable String passphrase) {
            Intrinsics.checkNotNullParameter((Object)certKeyComboSource, (String)"certKeyComboSource");
            List certificates = new ArrayList();
            List privateRsaKeys = new ArrayList();
            List privateKeys = new ArrayList();
            Iterator<String> lines = this.lines(certKeyComboSource).iterator();
            while (lines.hasNext()) {
                String line = lines.next();
                CharSequence charSequence = line;
                if (new Regex("-+BEGIN CERTIFICATE-+").matches(charSequence)) {
                    ((Collection)certificates).add(this.decodeBase64Until(lines, new Regex("-+END CERTIFICATE-+")));
                    continue;
                }
                charSequence = line;
                if (new Regex("-+BEGIN RSA PRIVATE KEY-+").matches(charSequence)) {
                    ((Collection)privateRsaKeys).add(this.decodeBase64Until(lines, new Regex("-+END RSA PRIVATE KEY-+")));
                    continue;
                }
                charSequence = line;
                if (!new Regex("-+BEGIN PRIVATE KEY-+").matches(charSequence)) continue;
                ((Collection)privateKeys).add(this.decodeBase64Until(lines, new Regex("-+END PRIVATE KEY-+")));
            }
            String string = passphrase;
            if (string == null) {
                string = "password";
            }
            return new PemComboFile(certificates, privateRsaKeys, privateKeys, string);
        }

        public static /* synthetic */ PemComboFile parse$default(Companion companion, BufferedSource bufferedSource, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = null;
            }
            return companion.parse(bufferedSource, string);
        }

        @NotNull
        public final KeySpec convertPKCS1toPKCS8(@NotNull ByteString pkcs1Key) {
            Intrinsics.checkNotNullParameter((Object)pkcs1Key, (String)"pkcs1Key");
            ASN1Primitive keyObject = ASN1Sequence.fromByteArray((byte[])pkcs1Key.toByteArray());
            RSAPrivateKey rsaPrivateKey = RSAPrivateKey.getInstance((Object)keyObject);
            return new RSAPrivateCrtKeySpec(rsaPrivateKey.getModulus(), rsaPrivateKey.getPublicExponent(), rsaPrivateKey.getPrivateExponent(), rsaPrivateKey.getPrime1(), rsaPrivateKey.getPrime2(), rsaPrivateKey.getExponent1(), rsaPrivateKey.getExponent2(), rsaPrivateKey.getCoefficient());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final List<String> lines(BufferedSource $this$lines) {
            Closeable closeable = (Closeable)$this$lines;
            Throwable throwable = null;
            try {
                BufferedSource it = (BufferedSource)closeable;
                boolean bl = false;
                List result = new ArrayList();
                while ($this$lines.readUtf8Line() != null) {
                    String line;
                    result.add(line);
                }
                List list = result;
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private final ByteString decodeBase64Until(Iterator<String> lines, Regex until) {
            Buffer result = new Buffer();
            while (true) {
                if (!lines.hasNext()) {
                    throw new IOException(until + " not found");
                }
                String line = lines.next();
                if (until.matches((CharSequence)line)) break;
                if (((CharSequence)line).length() == 0) continue;
                result.writeUtf8(line);
            }
            ByteString byteString = ByteString.Companion.decodeBase64(result.readUtf8());
            if (byteString == null) {
                throw new IOException("malformed base64");
            }
            return byteString;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

