/*
 * Decompiled with CFR 0.152.
 */
package wisp.task;

import com.github.michaelbull.retry.RetryFailure;
import com.github.michaelbull.retry.RetryInstruction;
import com.github.michaelbull.retry.policy.BackoffKt;
import com.github.michaelbull.retry.policy.RetryPolicyKt;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import wisp.task.RepeatedTask;
import wisp.task.RepeatedTaskConfig;
import wisp.task.RepeatedTaskKt;
import wisp.task.Status;
import wisp.task.TaskConfig;
import wisp.task.exception.NoTaskFoundException;
import wisp.task.exception.TaskAlreadyExistsException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u009c\u0001\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2/\b\u0002\u0010\r\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\b\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u001526\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\u0017\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0017\u0012\b\b\n\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00180\u000eH\u0007\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0007J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010\u001b\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lwisp/task/RepeatedTaskManager;", "", "meterRegistry", "Lio/micrometer/core/instrument/MeterRegistry;", "(Lio/micrometer/core/instrument/MeterRegistry;)V", "repeatedTasks", "", "", "Lwisp/task/RepeatedTask;", "createTask", "name", "repeatedTaskConfig", "Lwisp/task/RepeatedTaskConfig;", "retryPolicy", "Lkotlin/Function2;", "Lcom/github/michaelbull/retry/RetryFailure;", "", "Lkotlin/coroutines/Continuation;", "Lcom/github/michaelbull/retry/RetryInstruction;", "Lkotlin/ExtensionFunctionType;", "taskConfig", "Lwisp/task/TaskConfig;", "task", "Lkotlin/ParameterName;", "Lwisp/task/Status;", "(Ljava/lang/String;Lio/micrometer/core/instrument/MeterRegistry;Lwisp/task/RepeatedTaskConfig;Lkotlin/jvm/functions/Function2;Lwisp/task/TaskConfig;Lkotlin/jvm/functions/Function2;)Lwisp/task/RepeatedTask;", "getTask", "taskName", "isTaskRunning", "", "shutDown", "", "taskExists", "wisp-task"})
@SourceDebugExtension(value={"SMAP\nRepeatedTaskManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RepeatedTaskManager.kt\nwisp/task/RepeatedTaskManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,77:1\n1855#2,2:78\n*S KotlinDebug\n*F\n+ 1 RepeatedTaskManager.kt\nwisp/task/RepeatedTaskManager\n*L\n74#1:78,2\n*E\n"})
public final class RepeatedTaskManager {
    @NotNull
    private final MeterRegistry meterRegistry;
    @NotNull
    private final Map<String, RepeatedTask> repeatedTasks;

    @JvmOverloads
    public RepeatedTaskManager(@NotNull MeterRegistry meterRegistry) {
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        this.meterRegistry = meterRegistry;
        this.repeatedTasks = new LinkedHashMap();
    }

    public /* synthetic */ RepeatedTaskManager(MeterRegistry meterRegistry, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            CompositeMeterRegistry compositeMeterRegistry = Metrics.globalRegistry;
            Intrinsics.checkNotNullExpressionValue((Object)compositeMeterRegistry, (String)"globalRegistry");
            meterRegistry = (MeterRegistry)compositeMeterRegistry;
        }
        this(meterRegistry);
    }

    @JvmOverloads
    @NotNull
    public final RepeatedTask createTask(@NotNull String name, @NotNull MeterRegistry meterRegistry, @NotNull RepeatedTaskConfig repeatedTaskConfig, @NotNull Function2<? super RetryFailure<Throwable>, ? super Continuation<? super RetryInstruction>, ? extends Object> retryPolicy, @NotNull TaskConfig taskConfig, @NotNull Function2<? super String, ? super TaskConfig, ? extends Status> task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)repeatedTaskConfig, (String)"repeatedTaskConfig");
        Intrinsics.checkNotNullParameter(retryPolicy, (String)"retryPolicy");
        Intrinsics.checkNotNullParameter((Object)taskConfig, (String)"taskConfig");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        if (this.taskExists(name)) {
            throw new TaskAlreadyExistsException(name);
        }
        RepeatedTask repeatedTask = new RepeatedTask(name, meterRegistry, repeatedTaskConfig, retryPolicy, taskConfig, task);
        this.repeatedTasks.put(name, repeatedTask);
        return repeatedTask;
    }

    public static /* synthetic */ RepeatedTask createTask$default(RepeatedTaskManager repeatedTaskManager, String string, MeterRegistry meterRegistry, RepeatedTaskConfig repeatedTaskConfig, Function2 function2, TaskConfig taskConfig, Function2 function22, int n, Object object) {
        if ((n & 2) != 0) {
            meterRegistry = repeatedTaskManager.meterRegistry;
        }
        if ((n & 4) != 0) {
            repeatedTaskConfig = new RepeatedTaskConfig(0L, 0L, 0L, 0L, 15, null);
        }
        if ((n & 8) != 0) {
            function2 = RetryPolicyKt.plus(RepeatedTaskKt.getDefaultThrowableRetryPolicy(), (Function2)BackoffKt.binaryExponentialBackoff((long)repeatedTaskConfig.getDefaultJitterMs(), (long)repeatedTaskConfig.getDefaultMaxDelayMs()));
        }
        if ((n & 0x10) != 0) {
            taskConfig = new TaskConfig();
        }
        return repeatedTaskManager.createTask(string, meterRegistry, repeatedTaskConfig, (Function2<? super RetryFailure<Throwable>, ? super Continuation<? super RetryInstruction>, ? extends Object>)function2, taskConfig, (Function2<? super String, ? super TaskConfig, ? extends Status>)function22);
    }

    @NotNull
    public final RepeatedTask getTask(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        RepeatedTask repeatedTask = this.repeatedTasks.get(taskName);
        if (repeatedTask == null) {
            throw new NoTaskFoundException(taskName);
        }
        return repeatedTask;
    }

    public final boolean taskExists(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        return this.repeatedTasks.containsKey(taskName);
    }

    public final boolean isTaskRunning(@NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        RepeatedTask repeatedTask = this.repeatedTasks.get(taskName);
        return repeatedTask != null ? repeatedTask.isRunning() : false;
    }

    public final void shutDown() {
        Iterable $this$forEach$iv = this.repeatedTasks.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RepeatedTask it = (RepeatedTask)element$iv;
            boolean bl = false;
            it.shutDown();
        }
    }

    @JvmOverloads
    public RepeatedTaskManager() {
        this(null, 1, null);
    }

    @JvmOverloads
    @NotNull
    public final RepeatedTask createTask(@NotNull String name, @NotNull MeterRegistry meterRegistry, @NotNull RepeatedTaskConfig repeatedTaskConfig, @NotNull Function2<? super RetryFailure<Throwable>, ? super Continuation<? super RetryInstruction>, ? extends Object> retryPolicy, @NotNull Function2<? super String, ? super TaskConfig, ? extends Status> task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)repeatedTaskConfig, (String)"repeatedTaskConfig");
        Intrinsics.checkNotNullParameter(retryPolicy, (String)"retryPolicy");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return RepeatedTaskManager.createTask$default(this, name, meterRegistry, repeatedTaskConfig, retryPolicy, null, task, 16, null);
    }

    @JvmOverloads
    @NotNull
    public final RepeatedTask createTask(@NotNull String name, @NotNull MeterRegistry meterRegistry, @NotNull RepeatedTaskConfig repeatedTaskConfig, @NotNull Function2<? super String, ? super TaskConfig, ? extends Status> task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter((Object)repeatedTaskConfig, (String)"repeatedTaskConfig");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return RepeatedTaskManager.createTask$default(this, name, meterRegistry, repeatedTaskConfig, null, null, task, 24, null);
    }

    @JvmOverloads
    @NotNull
    public final RepeatedTask createTask(@NotNull String name, @NotNull MeterRegistry meterRegistry, @NotNull Function2<? super String, ? super TaskConfig, ? extends Status> task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)meterRegistry, (String)"meterRegistry");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return RepeatedTaskManager.createTask$default(this, name, meterRegistry, null, null, null, task, 28, null);
    }

    @JvmOverloads
    @NotNull
    public final RepeatedTask createTask(@NotNull String name, @NotNull Function2<? super String, ? super TaskConfig, ? extends Status> task) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(task, (String)"task");
        return RepeatedTaskManager.createTask$default(this, name, null, null, null, null, task, 30, null);
    }
}

