package app.cash.zipline.loader.`internal`.cache

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface PinsQueries : Transacter {
  public fun count(): Query<Long>

  public fun <T : Any> get_pin(
    file_id: Long,
    application_name: String,
    mapper: (file_id: Long, application_name: String) -> T
  ): Query<T>

  public fun get_pin(file_id: Long, application_name: String): Query<Pins>

  public fun delete_pin(application_name: String, file_id: Long): Unit

  public fun delete_application_pins(application_name: String): Unit

  public fun create_pin(file_id: Long, application_name: String): Unit
}
