package app.cash.zipline.loader.`internal`.cache

import app.cash.zipline.loader.`internal`.cache.ziplineloader.newInstance
import app.cash.zipline.loader.`internal`.cache.ziplineloader.schema
import com.squareup.sqldelight.Transacter
import com.squareup.sqldelight.db.SqlDriver

public interface Database : Transacter {
  public val filesQueries: FilesQueries

  public val pinsQueries: PinsQueries

  public companion object {
    public val Schema: SqlDriver.Schema
      get() = Database::class.schema

    public operator fun invoke(driver: SqlDriver, filesAdapter: Files.Adapter): Database =
        Database::class.newInstance(driver, filesAdapter)
  }
}
