package app.cash.zipline.loader.`internal`.cache.ziplineloader

import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.AfterVersion
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import app.cash.zipline.loader.`internal`.cache.Database
import app.cash.zipline.loader.`internal`.cache.Files
import app.cash.zipline.loader.`internal`.cache.FilesQueries
import app.cash.zipline.loader.`internal`.cache.PinsQueries
import kotlin.Long
import kotlin.Unit
import kotlin.reflect.KClass

internal val KClass<Database>.schema: SqlSchema<QueryResult.Value<Unit>>
  get() = DatabaseImpl.Schema

internal fun KClass<Database>.newInstance(driver: SqlDriver, filesAdapter: Files.Adapter): Database
    = DatabaseImpl(driver, filesAdapter)

private class DatabaseImpl(
  driver: SqlDriver,
  filesAdapter: Files.Adapter,
) : TransacterImpl(driver), Database {
  override val filesQueries: FilesQueries = FilesQueries(driver, filesAdapter)

  override val pinsQueries: PinsQueries = PinsQueries(driver)

  public object Schema : SqlSchema<QueryResult.Value<Unit>> {
    override val version: Long
      get() = 1

    override fun create(driver: SqlDriver): QueryResult.Value<Unit> {
      driver.execute(null, """
          |CREATE TABLE files (
          |  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
          |  sha256_hex TEXT NOT NULL,
          |  manifest_for_application_name TEXT, -- LIKE 'red' or maybe 'red.manifest.json', null for all files except manifest
          |  file_state TEXT NOT NULL,
          |  size_bytes INTEGER NOT NULL,
          |  last_used_at_epoch_ms INTEGER NOT NULL,
          |  fresh_at_epoch_ms INTEGER -- null for all files except manifest
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE pins (
          |  file_id INTEGER NOT NULL,
          |  application_name TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, "CREATE UNIQUE INDEX files_sha256_hex ON files(sha256_hex)", 0)
      driver.execute(null,
          "CREATE UNIQUE INDEX pins_file_id_application_name ON pins(file_id, application_name)", 0)
      driver.execute(null, "CREATE INDEX pins_application_name ON pins(application_name)", 0)
      return QueryResult.Unit
    }

    override fun migrate(
      driver: SqlDriver,
      oldVersion: Long,
      newVersion: Long,
      vararg callbacks: AfterVersion,
    ): QueryResult.Value<Unit> = QueryResult.Unit
  }
}
