package app.cash.zipline.loader.`internal`.cache

import app.cash.sqldelight.Transacter
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlDriver
import app.cash.sqldelight.db.SqlSchema
import app.cash.zipline.loader.`internal`.cache.ziplineloader.newInstance
import app.cash.zipline.loader.`internal`.cache.ziplineloader.schema
import kotlin.Unit

public interface Database : Transacter {
  public val filesQueries: FilesQueries

  public val pinsQueries: PinsQueries

  public companion object {
    public val Schema: SqlSchema<QueryResult.Value<Unit>>
      get() = Database::class.schema

    public operator fun invoke(driver: SqlDriver, filesAdapter: Files.Adapter): Database =
        Database::class.newInstance(driver, filesAdapter)
  }
}
