package app.cash.zipline.loader.`internal`.cache.ziplineloader

import app.cash.zipline.loader.`internal`.cache.Database
import app.cash.zipline.loader.`internal`.cache.FileState
import app.cash.zipline.loader.`internal`.cache.Files
import app.cash.zipline.loader.`internal`.cache.FilesQueries
import app.cash.zipline.loader.`internal`.cache.Pins
import app.cash.zipline.loader.`internal`.cache.PinsQueries
import app.cash.zipline.loader.`internal`.cache.SelectCacheSumBytes
import com.squareup.sqldelight.Query
import com.squareup.sqldelight.TransacterImpl
import com.squareup.sqldelight.`internal`.copyOnWriteList
import com.squareup.sqldelight.db.SqlCursor
import com.squareup.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Unit
import kotlin.collections.MutableList
import kotlin.reflect.KClass

internal val KClass<Database>.schema: SqlDriver.Schema
  get() = DatabaseImpl.Schema

internal fun KClass<Database>.newInstance(driver: SqlDriver, filesAdapter: Files.Adapter): Database
    = DatabaseImpl(driver, filesAdapter)

private class DatabaseImpl(
  driver: SqlDriver,
  internal val filesAdapter: Files.Adapter
) : TransacterImpl(driver), Database {
  public override val filesQueries: FilesQueriesImpl = FilesQueriesImpl(this, driver)

  public override val pinsQueries: PinsQueriesImpl = PinsQueriesImpl(this, driver)

  public object Schema : SqlDriver.Schema {
    public override val version: Int
      get() = 1

    public override fun create(driver: SqlDriver): Unit {
      driver.execute(null, """
          |CREATE TABLE files (
          |  id INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
          |  sha256_hex TEXT NOT NULL,
          |  manifest_for_application_name TEXT, -- LIKE 'red' or maybe 'red.manifest.json', null for all files except manifest
          |  file_state TEXT NOT NULL,
          |  size_bytes INTEGER NOT NULL,
          |  last_used_at_epoch_ms INTEGER NOT NULL,
          |  fresh_at_epoch_ms INTEGER -- null for all files except manifest
          |)
          """.trimMargin(), 0)
      driver.execute(null, """
          |CREATE TABLE pins (
          |  file_id INTEGER NOT NULL,
          |  application_name TEXT NOT NULL
          |)
          """.trimMargin(), 0)
      driver.execute(null, "CREATE UNIQUE INDEX files_sha256_hex ON files(sha256_hex)", 0)
      driver.execute(null,
          "CREATE UNIQUE INDEX pins_file_id_application_name ON pins(file_id, application_name)", 0)
      driver.execute(null, "CREATE INDEX pins_application_name ON pins(application_name)", 0)
    }

    public override fun migrate(
      driver: SqlDriver,
      oldVersion: Int,
      newVersion: Int
    ): Unit {
    }
  }
}

private class FilesQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), FilesQueries {
  internal val selectCacheSumBytes: MutableList<Query<*>> = copyOnWriteList()

  internal val count: MutableList<Query<*>> = copyOnWriteList()

  internal val `get`: MutableList<Query<*>> = copyOnWriteList()

  internal val getById: MutableList<Query<*>> = copyOnWriteList()

  internal val selectOldestReady: MutableList<Query<*>> = copyOnWriteList()

  internal val selectPinnedManifest: MutableList<Query<*>> = copyOnWriteList()

  internal val selectPinnedManifestNotFileId: MutableList<Query<*>> = copyOnWriteList()

  internal val selectAnyDirtyFile: MutableList<Query<*>> = copyOnWriteList()

  public override fun <T : Any> selectCacheSumBytes(mapper: (SUM: Long?) -> T): Query<T> =
      Query(342963574, selectCacheSumBytes, driver, "Files.sq", "selectCacheSumBytes", """
  |SELECT SUM(size_bytes)
  |FROM files
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)
    )
  }

  public override fun selectCacheSumBytes(): Query<SelectCacheSumBytes> = selectCacheSumBytes {
      SUM ->
    SelectCacheSumBytes(
      SUM
    )
  }

  public override fun count(): Query<Long> = Query(942248863, count, driver, "Files.sq", "count",
      "SELECT COUNT(*) FROM files") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun <T : Any> `get`(sha256_hex: String, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T> = GetQuery(sha256_hex) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      database.filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public override fun `get`(sha256_hex: String): Query<Files> = get(sha256_hex) { id, sha256_hex_,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex_,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public override fun <T : Any> getById(id: Long, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T> = GetByIdQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      database.filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public override fun getById(id: Long): Query<Files> = getById(id) { id_, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id_,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public override fun <T : Any> selectOldestReady(mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T> = Query(-533945640, selectOldestReady, driver, "Files.sq", "selectOldestReady",
      """
  |SELECT
  |id,
  |sha256_hex,
  |manifest_for_application_name,
  |file_state,
  |size_bytes,
  |last_used_at_epoch_ms,
  |fresh_at_epoch_ms
  |FROM files f
  |LEFT JOIN pins p ON (f.id = p.file_id)
  |WHERE
  |  p.file_id IS NULL AND
  |  f.file_state = 'READY'
  |ORDER BY last_used_at_epoch_ms ASC
  |LIMIT 1
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      database.filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public override fun selectOldestReady(): Query<Files> = selectOldestReady { id, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public override fun <T : Any> selectPinnedManifest(manifest_for_application_name: String?,
      mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T> = SelectPinnedManifestQuery(manifest_for_application_name) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      database.filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public override fun selectPinnedManifest(manifest_for_application_name: String?): Query<Files> =
      selectPinnedManifest(manifest_for_application_name) { id, sha256_hex,
      manifest_for_application_name_, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name_,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public override fun <T : Any> selectPinnedManifestNotFileId(
    application_name: String?,
    not_file_id: Long,
    mapper: (
      id: Long,
      sha256_hex: String,
      manifest_for_application_name: String?,
      file_state: FileState,
      size_bytes: Long,
      last_used_at_epoch_ms: Long,
      fresh_at_epoch_ms: Long?
    ) -> T
  ): Query<T> = SelectPinnedManifestNotFileIdQuery(application_name, not_file_id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      database.filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public override fun selectPinnedManifestNotFileId(application_name: String?, not_file_id: Long):
      Query<Files> = selectPinnedManifestNotFileId(application_name, not_file_id) { id, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public override fun <T : Any> selectAnyDirtyFile(mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T> = Query(-1826080146, selectAnyDirtyFile, driver, "Files.sq",
      "selectAnyDirtyFile", """
  |SELECT *
  |FROM files f
  |WHERE f.file_state = 'DIRTY'
  |LIMIT 1
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      database.filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public override fun selectAnyDirtyFile(): Query<Files> = selectAnyDirtyFile { id, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public override fun insert(
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ): Unit {
    driver.execute(-684273111, """
    |INSERT INTO files(sha256_hex, manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms, fresh_at_epoch_ms)
    |VALUES (?, ?, ?, ?, ?, ?)
    """.trimMargin(), 6) {
      bindString(1, sha256_hex)
      bindString(2, manifest_for_application_name)
      bindString(3, database.filesAdapter.file_stateAdapter.encode(file_state))
      bindLong(4, size_bytes)
      bindLong(5, last_used_at_epoch_ms)
      bindLong(6, fresh_at_epoch_ms)
    }
    notifyQueries(-684273111, {database.filesQueries.selectAnyDirtyFile +
        database.filesQueries.getById + database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.filesQueries.get +
        database.filesQueries.selectCacheSumBytes + database.filesQueries.count +
        database.filesQueries.selectPinnedManifestNotFileId})
  }

  public override fun update(
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    id: Long
  ): Unit {
    driver.execute(-339326919, """
    |UPDATE files
    |SET file_state = ?, size_bytes = ?, last_used_at_epoch_ms = ?
    |WHERE id = ?
    """.trimMargin(), 4) {
      bindString(1, database.filesAdapter.file_stateAdapter.encode(file_state))
      bindLong(2, size_bytes)
      bindLong(3, last_used_at_epoch_ms)
      bindLong(4, id)
    }
    notifyQueries(-339326919, {database.filesQueries.selectAnyDirtyFile +
        database.filesQueries.getById + database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.filesQueries.get +
        database.filesQueries.selectCacheSumBytes + database.filesQueries.count +
        database.filesQueries.selectPinnedManifestNotFileId})
  }

  public override fun updateFresh(fresh_at_epoch_ms: Long?, id: Long): Unit {
    driver.execute(-1036338059, """
    |UPDATE files
    |SET fresh_at_epoch_ms = ?
    |WHERE id = ?
    """.trimMargin(), 2) {
      bindLong(1, fresh_at_epoch_ms)
      bindLong(2, id)
    }
    notifyQueries(-1036338059, {database.filesQueries.selectAnyDirtyFile +
        database.filesQueries.getById + database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.filesQueries.get +
        database.filesQueries.selectCacheSumBytes + database.filesQueries.count +
        database.filesQueries.selectPinnedManifestNotFileId})
  }

  public override fun delete(id: Long): Unit {
    driver.execute(-835939045, """
    |DELETE FROM files
    |WHERE id = ?
    """.trimMargin(), 1) {
      bindLong(1, id)
    }
    notifyQueries(-835939045, {database.filesQueries.selectAnyDirtyFile +
        database.filesQueries.getById + database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.filesQueries.get +
        database.filesQueries.selectCacheSumBytes + database.filesQueries.count +
        database.filesQueries.selectPinnedManifestNotFileId})
  }

  private inner class GetQuery<out T : Any>(
    public val sha256_hex: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(get, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(5453286, """
    |SELECT *
    |FROM files
    |WHERE sha256_hex LIKE ('%' || ?)
    |LIMIT 1
    """.trimMargin(), 1) {
      bindString(1, sha256_hex)
    }

    public override fun toString(): String = "Files.sq:get"
  }

  private inner class GetByIdQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(getById, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(-1770413352, """
    |SELECT *
    |FROM files
    |WHERE id = ?
    |LIMIT 1
    """.trimMargin(), 1) {
      bindLong(1, id)
    }

    public override fun toString(): String = "Files.sq:getById"
  }

  private inner class SelectPinnedManifestQuery<out T : Any>(
    public val manifest_for_application_name: String?,
    mapper: (SqlCursor) -> T
  ) : Query<T>(selectPinnedManifest, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(null, """
    |SELECT
    |id,
    |sha256_hex,
    |manifest_for_application_name,
    |file_state,
    |size_bytes,
    |last_used_at_epoch_ms,
    |fresh_at_epoch_ms
    |FROM files f
    |LEFT JOIN pins p ON (
    |  f.id = p.file_id AND
    |  f.manifest_for_application_name = p.application_name
    |)
    |WHERE f.manifest_for_application_name ${ if (manifest_for_application_name == null) "IS" else "=" } ?
    |ORDER BY id DESC
    |LIMIT 1
    """.trimMargin(), 1) {
      bindString(1, manifest_for_application_name)
    }

    public override fun toString(): String = "Files.sq:selectPinnedManifest"
  }

  private inner class SelectPinnedManifestNotFileIdQuery<out T : Any>(
    public val application_name: String?,
    public val not_file_id: Long,
    mapper: (SqlCursor) -> T
  ) : Query<T>(selectPinnedManifestNotFileId, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(null, """
    |SELECT
    |id,
    |sha256_hex,
    |manifest_for_application_name,
    |file_state,
    |size_bytes,
    |last_used_at_epoch_ms,
    |fresh_at_epoch_ms
    |FROM files f
    |LEFT JOIN pins p ON (
    |  f.id = p.file_id AND
    |  f.manifest_for_application_name = p.application_name
    |)
    |WHERE f.manifest_for_application_name ${ if (application_name == null) "IS" else "=" } ? AND f.id != ?
    |ORDER BY id DESC
    |LIMIT 1
    """.trimMargin(), 2) {
      bindString(1, application_name)
      bindLong(2, not_file_id)
    }

    public override fun toString(): String = "Files.sq:selectPinnedManifestNotFileId"
  }
}

private class PinsQueriesImpl(
  private val database: DatabaseImpl,
  private val driver: SqlDriver
) : TransacterImpl(driver), PinsQueries {
  internal val count: MutableList<Query<*>> = copyOnWriteList()

  internal val get_pin: MutableList<Query<*>> = copyOnWriteList()

  public override fun count(): Query<Long> = Query(618474414, count, driver, "Pins.sq", "count",
      "SELECT COUNT(*) FROM pins") { cursor ->
    cursor.getLong(0)!!
  }

  public override fun <T : Any> get_pin(
    file_id: Long,
    application_name: String,
    mapper: (file_id: Long, application_name: String) -> T
  ): Query<T> = Get_pinQuery(file_id, application_name) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!
    )
  }

  public override fun get_pin(file_id: Long, application_name: String): Query<Pins> =
      get_pin(file_id, application_name) { file_id_, application_name_ ->
    Pins(
      file_id_,
      application_name_
    )
  }

  public override fun delete_pin(application_name: String, file_id: Long): Unit {
    driver.execute(-1830319678, """DELETE FROM pins WHERE application_name = ? AND file_id = ?""",
        2) {
      bindString(1, application_name)
      bindLong(2, file_id)
    }
    notifyQueries(-1830319678, {database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.pinsQueries.get_pin +
        database.pinsQueries.count + database.filesQueries.selectPinnedManifestNotFileId})
  }

  public override fun delete_application_pins(application_name: String): Unit {
    driver.execute(-547381248, """DELETE FROM pins WHERE application_name = ?""", 1) {
      bindString(1, application_name)
    }
    notifyQueries(-547381248, {database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.pinsQueries.get_pin +
        database.pinsQueries.count + database.filesQueries.selectPinnedManifestNotFileId})
  }

  public override fun create_pin(file_id: Long, application_name: String): Unit {
    driver.execute(2069271699, """
    |INSERT INTO pins(file_id, application_name)
    |VALUES (?, ?)
    """.trimMargin(), 2) {
      bindLong(1, file_id)
      bindString(2, application_name)
    }
    notifyQueries(2069271699, {database.filesQueries.selectPinnedManifest +
        database.filesQueries.selectOldestReady + database.pinsQueries.get_pin +
        database.pinsQueries.count + database.filesQueries.selectPinnedManifestNotFileId})
  }

  private inner class Get_pinQuery<out T : Any>(
    public val file_id: Long,
    public val application_name: String,
    mapper: (SqlCursor) -> T
  ) : Query<T>(get_pin, mapper) {
    public override fun execute(): SqlCursor = driver.executeQuery(615810059,
        """SELECT * FROM pins WHERE file_id = ? AND application_name = ?""", 2) {
      bindLong(1, file_id)
      bindString(2, application_name)
    }

    public override fun toString(): String = "Pins.sq:get_pin"
  }
}
