package app.cash.zipline.loader.`internal`.cache

import com.squareup.sqldelight.Query
import com.squareup.sqldelight.Transacter
import kotlin.Any
import kotlin.Long
import kotlin.String
import kotlin.Unit

public interface FilesQueries : Transacter {
  public fun <T : Any> selectCacheSumBytes(mapper: (SUM: Long?) -> T): Query<T>

  public fun selectCacheSumBytes(): Query<SelectCacheSumBytes>

  public fun count(): Query<Long>

  public fun <T : Any> `get`(sha256_hex: String, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T>

  public fun `get`(sha256_hex: String): Query<Files>

  public fun <T : Any> getById(id: Long, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T>

  public fun getById(id: Long): Query<Files>

  public fun <T : Any> selectOldestReady(mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T>

  public fun selectOldestReady(): Query<Files>

  public fun <T : Any> selectPinnedManifest(manifest_for_application_name: String?, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T>

  public fun selectPinnedManifest(manifest_for_application_name: String?): Query<Files>

  public fun <T : Any> selectPinnedManifestNotFileId(
    application_name: String?,
    not_file_id: Long,
    mapper: (
      id: Long,
      sha256_hex: String,
      manifest_for_application_name: String?,
      file_state: FileState,
      size_bytes: Long,
      last_used_at_epoch_ms: Long,
      fresh_at_epoch_ms: Long?
    ) -> T
  ): Query<T>

  public fun selectPinnedManifestNotFileId(application_name: String?, not_file_id: Long):
      Query<Files>

  public fun <T : Any> selectAnyDirtyFile(mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ) -> T): Query<T>

  public fun selectAnyDirtyFile(): Query<Files>

  public fun insert(
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?
  ): Unit

  public fun update(
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    id: Long
  ): Unit

  public fun updateFresh(fresh_at_epoch_ms: Long?, id: Long): Unit

  public fun delete(id: Long): Unit
}
