package app.cash.zipline.loader.`internal`.cache

import com.squareup.sqldelight.ColumnAdapter
import kotlin.Long
import kotlin.String

public data class Files(
  public val id: Long,
  public val sha256_hex: String,
  public val manifest_for_application_name: String?,
  public val file_state: FileState,
  public val size_bytes: Long,
  public val last_used_at_epoch_ms: Long,
  public val fresh_at_epoch_ms: Long?
) {
  public override fun toString(): String = """
  |Files [
  |  id: $id
  |  sha256_hex: $sha256_hex
  |  manifest_for_application_name: $manifest_for_application_name
  |  file_state: $file_state
  |  size_bytes: $size_bytes
  |  last_used_at_epoch_ms: $last_used_at_epoch_ms
  |  fresh_at_epoch_ms: $fresh_at_epoch_ms
  |]
  """.trimMargin()

  public class Adapter(
    public val file_stateAdapter: ColumnAdapter<FileState, String>
  )
}
