package app.cash.zipline.loader.`internal`.cache

import app.cash.sqldelight.Query
import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String

public class FilesQueries(
  driver: SqlDriver,
  private val filesAdapter: Files.Adapter,
) : TransacterImpl(driver) {
  public fun <T : Any> selectCacheSumBytes(mapper: (SUM: Long?) -> T): Query<T> = Query(342_963_574,
      arrayOf("files"), driver, "Files.sq", "selectCacheSumBytes", """
  |SELECT SUM(size_bytes)
  |FROM files
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)
    )
  }

  public fun selectCacheSumBytes(): Query<SelectCacheSumBytes> = selectCacheSumBytes { SUM ->
    SelectCacheSumBytes(
      SUM
    )
  }

  public fun count(): Query<Long> = Query(942_248_863, arrayOf("files"), driver, "Files.sq",
      "count", "SELECT COUNT(*) FROM files") { cursor ->
    cursor.getLong(0)!!
  }

  public fun <T : Any> `get`(sha256_hex: String, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?,
  ) -> T): Query<T> = GetQuery(sha256_hex) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public fun `get`(sha256_hex: String): Query<Files> = get(sha256_hex) { id, sha256_hex_,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex_,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public fun <T : Any> getById(id: Long, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?,
  ) -> T): Query<T> = GetByIdQuery(id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public fun getById(id: Long): Query<Files> = getById(id) { id_, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id_,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public fun <T : Any> selectOldestReady(mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?,
  ) -> T): Query<T> = Query(-533_945_640, arrayOf("files", "pins"), driver, "Files.sq",
      "selectOldestReady", """
  |SELECT
  |id,
  |sha256_hex,
  |manifest_for_application_name,
  |file_state,
  |size_bytes,
  |last_used_at_epoch_ms,
  |fresh_at_epoch_ms
  |FROM files f
  |LEFT JOIN pins p ON (f.id = p.file_id)
  |WHERE
  |  p.file_id IS NULL AND
  |  f.file_state = 'READY'
  |ORDER BY last_used_at_epoch_ms ASC
  |LIMIT 1
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public fun selectOldestReady(): Query<Files> = selectOldestReady { id, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public fun <T : Any> selectPinnedManifest(manifest_for_application_name: String?, mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?,
  ) -> T): Query<T> = SelectPinnedManifestQuery(manifest_for_application_name) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public fun selectPinnedManifest(manifest_for_application_name: String?): Query<Files> =
      selectPinnedManifest(manifest_for_application_name) { id, sha256_hex,
      manifest_for_application_name_, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name_,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public fun <T : Any> selectPinnedManifestNotFileId(
    application_name: String?,
    not_file_id: Long,
    mapper: (
      id: Long,
      sha256_hex: String,
      manifest_for_application_name: String?,
      file_state: FileState,
      size_bytes: Long,
      last_used_at_epoch_ms: Long,
      fresh_at_epoch_ms: Long?,
    ) -> T,
  ): Query<T> = SelectPinnedManifestNotFileIdQuery(application_name, not_file_id) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public fun selectPinnedManifestNotFileId(application_name: String?, not_file_id: Long):
      Query<Files> = selectPinnedManifestNotFileId(application_name, not_file_id) { id, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public fun <T : Any> selectAnyDirtyFile(mapper: (
    id: Long,
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?,
  ) -> T): Query<T> = Query(-1_826_080_146, arrayOf("files"), driver, "Files.sq",
      "selectAnyDirtyFile", """
  |SELECT *
  |FROM files f
  |WHERE f.file_state = 'DIRTY'
  |LIMIT 1
  """.trimMargin()) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!,
      cursor.getString(2),
      filesAdapter.file_stateAdapter.decode(cursor.getString(3)!!),
      cursor.getLong(4)!!,
      cursor.getLong(5)!!,
      cursor.getLong(6)
    )
  }

  public fun selectAnyDirtyFile(): Query<Files> = selectAnyDirtyFile { id, sha256_hex,
      manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms,
      fresh_at_epoch_ms ->
    Files(
      id,
      sha256_hex,
      manifest_for_application_name,
      file_state,
      size_bytes,
      last_used_at_epoch_ms,
      fresh_at_epoch_ms
    )
  }

  public fun insert(
    sha256_hex: String,
    manifest_for_application_name: String?,
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    fresh_at_epoch_ms: Long?,
  ) {
    driver.execute(-684_273_111, """
        |INSERT INTO files(sha256_hex, manifest_for_application_name, file_state, size_bytes, last_used_at_epoch_ms, fresh_at_epoch_ms)
        |VALUES (?, ?, ?, ?, ?, ?)
        """.trimMargin(), 6) {
          bindString(0, sha256_hex)
          bindString(1, manifest_for_application_name)
          bindString(2, filesAdapter.file_stateAdapter.encode(file_state))
          bindLong(3, size_bytes)
          bindLong(4, last_used_at_epoch_ms)
          bindLong(5, fresh_at_epoch_ms)
        }
    notifyQueries(-684_273_111) { emit ->
      emit("files")
    }
  }

  public fun update(
    file_state: FileState,
    size_bytes: Long,
    last_used_at_epoch_ms: Long,
    id: Long,
  ) {
    driver.execute(-339_326_919, """
        |UPDATE files
        |SET file_state = ?, size_bytes = ?, last_used_at_epoch_ms = ?
        |WHERE id = ?
        """.trimMargin(), 4) {
          bindString(0, filesAdapter.file_stateAdapter.encode(file_state))
          bindLong(1, size_bytes)
          bindLong(2, last_used_at_epoch_ms)
          bindLong(3, id)
        }
    notifyQueries(-339_326_919) { emit ->
      emit("files")
    }
  }

  public fun updateFresh(fresh_at_epoch_ms: Long?, id: Long) {
    driver.execute(-1_036_338_059, """
        |UPDATE files
        |SET fresh_at_epoch_ms = ?
        |WHERE id = ?
        """.trimMargin(), 2) {
          bindLong(0, fresh_at_epoch_ms)
          bindLong(1, id)
        }
    notifyQueries(-1_036_338_059) { emit ->
      emit("files")
    }
  }

  public fun delete(id: Long) {
    driver.execute(-835_939_045, """
        |DELETE FROM files
        |WHERE id = ?
        """.trimMargin(), 1) {
          bindLong(0, id)
        }
    notifyQueries(-835_939_045) { emit ->
      emit("files")
    }
  }

  private inner class GetQuery<out T : Any>(
    public val sha256_hex: String,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("files", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("files", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(5_453_286, """
    |SELECT *
    |FROM files
    |WHERE sha256_hex LIKE ('%' || ?)
    |LIMIT 1
    """.trimMargin(), mapper, 1) {
      bindString(0, sha256_hex)
    }

    override fun toString(): String = "Files.sq:get"
  }

  private inner class GetByIdQuery<out T : Any>(
    public val id: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("files", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("files", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(-1_770_413_352, """
    |SELECT *
    |FROM files
    |WHERE id = ?
    |LIMIT 1
    """.trimMargin(), mapper, 1) {
      bindLong(0, id)
    }

    override fun toString(): String = "Files.sq:getById"
  }

  private inner class SelectPinnedManifestQuery<out T : Any>(
    public val manifest_for_application_name: String?,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("files", "pins", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("files", "pins", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(null, """
    |SELECT
    |id,
    |sha256_hex,
    |manifest_for_application_name,
    |file_state,
    |size_bytes,
    |last_used_at_epoch_ms,
    |fresh_at_epoch_ms
    |FROM files f
    |LEFT JOIN pins p ON (
    |  f.id = p.file_id AND
    |  f.manifest_for_application_name = p.application_name
    |)
    |WHERE f.manifest_for_application_name ${ if (manifest_for_application_name == null) "IS" else "=" } ?
    |ORDER BY id DESC
    |LIMIT 1
    """.trimMargin(), mapper, 1) {
      bindString(0, manifest_for_application_name)
    }

    override fun toString(): String = "Files.sq:selectPinnedManifest"
  }

  private inner class SelectPinnedManifestNotFileIdQuery<out T : Any>(
    public val application_name: String?,
    public val not_file_id: Long,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("files", "pins", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("files", "pins", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(null, """
    |SELECT
    |id,
    |sha256_hex,
    |manifest_for_application_name,
    |file_state,
    |size_bytes,
    |last_used_at_epoch_ms,
    |fresh_at_epoch_ms
    |FROM files f
    |LEFT JOIN pins p ON (
    |  f.id = p.file_id AND
    |  f.manifest_for_application_name = p.application_name
    |)
    |WHERE f.manifest_for_application_name ${ if (application_name == null) "IS" else "=" } ? AND f.id != ?
    |ORDER BY id DESC
    |LIMIT 1
    """.trimMargin(), mapper, 2) {
      bindString(0, application_name)
      bindLong(1, not_file_id)
    }

    override fun toString(): String = "Files.sq:selectPinnedManifestNotFileId"
  }
}
