package app.cash.zipline.loader.`internal`.cache

import app.cash.sqldelight.Query
import app.cash.sqldelight.TransacterImpl
import app.cash.sqldelight.db.QueryResult
import app.cash.sqldelight.db.SqlCursor
import app.cash.sqldelight.db.SqlDriver
import kotlin.Any
import kotlin.Long
import kotlin.String

public class PinsQueries(
  driver: SqlDriver,
) : TransacterImpl(driver) {
  public fun count(): Query<Long> = Query(618_474_414, arrayOf("pins"), driver, "Pins.sq", "count",
      "SELECT COUNT(*) FROM pins") { cursor ->
    cursor.getLong(0)!!
  }

  public fun <T : Any> get_pin(
    file_id: Long,
    application_name: String,
    mapper: (file_id: Long, application_name: String) -> T,
  ): Query<T> = Get_pinQuery(file_id, application_name) { cursor ->
    mapper(
      cursor.getLong(0)!!,
      cursor.getString(1)!!
    )
  }

  public fun get_pin(file_id: Long, application_name: String): Query<Pins> = get_pin(file_id,
      application_name) { file_id_, application_name_ ->
    Pins(
      file_id_,
      application_name_
    )
  }

  public fun delete_pin(application_name: String, file_id: Long) {
    driver.execute(-1_830_319_678,
        """DELETE FROM pins WHERE application_name = ? AND file_id = ?""", 2) {
          bindString(0, application_name)
          bindLong(1, file_id)
        }
    notifyQueries(-1_830_319_678) { emit ->
      emit("pins")
    }
  }

  public fun delete_application_pins(application_name: String) {
    driver.execute(-547_381_248, """DELETE FROM pins WHERE application_name = ?""", 1) {
          bindString(0, application_name)
        }
    notifyQueries(-547_381_248) { emit ->
      emit("pins")
    }
  }

  public fun create_pin(file_id: Long, application_name: String) {
    driver.execute(2_069_271_699, """
        |INSERT INTO pins(file_id, application_name)
        |VALUES (?, ?)
        """.trimMargin(), 2) {
          bindLong(0, file_id)
          bindString(1, application_name)
        }
    notifyQueries(2_069_271_699) { emit ->
      emit("pins")
    }
  }

  private inner class Get_pinQuery<out T : Any>(
    public val file_id: Long,
    public val application_name: String,
    mapper: (SqlCursor) -> T,
  ) : Query<T>(mapper) {
    override fun addListener(listener: Query.Listener) {
      driver.addListener("pins", listener = listener)
    }

    override fun removeListener(listener: Query.Listener) {
      driver.removeListener("pins", listener = listener)
    }

    override fun <R> execute(mapper: (SqlCursor) -> QueryResult<R>): QueryResult<R> =
        driver.executeQuery(615_810_059,
        """SELECT * FROM pins WHERE file_id = ? AND application_name = ?""", mapper, 2) {
      bindLong(0, file_id)
      bindString(1, application_name)
    }

    override fun toString(): String = "Pins.sq:get_pin"
  }
}
