/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa;

import app.commerceio.spring.data.search.Mapper;
import app.commerceio.spring.data.search.SearchLexer;
import app.commerceio.spring.data.search.SearchParser;
import app.commerceio.spring.data.search.jpa.SearchVisitorImpl;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class SearchBuilder {
    public <T> Specification<T> parse(String search) {
        return this.parse(search, (Mapper)Mapper.flatMapper().build());
    }

    public <T> Specification<T> parse(String search, Mapper mapper) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return null;
        }
        SearchVisitorImpl searchVisitor = SearchVisitorImpl.builder().mapper(mapper).build();
        SearchParser parser = this.getParser(search);
        return (Specification)searchVisitor.visit((ParseTree)parser.input());
    }

    private SearchParser getParser(String search) {
        SearchLexer lexer = new SearchLexer((CharStream)CharStreams.fromString((String)search));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new SearchParser((TokenStream)tokens);
    }
}

