/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa;

import app.commerceio.spring.data.search.SearchOp;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.criteria.From;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Root;
import org.apache.commons.lang3.StringUtils;

public class SearchCriteria {
    private boolean exists;
    private String key;
    private SearchOp op;
    private String value;
    private Path<?> path;
    private boolean isArray;
    private Class<?> type;
    private boolean startsWith;
    private boolean endsWith;

    public static SearchCriteriaBuilder builder() {
        return new SearchCriteriaBuilder();
    }

    public boolean isExists() {
        return this.exists;
    }

    public String getKey() {
        return this.key;
    }

    public SearchOp getOp() {
        return this.op;
    }

    public String getValue() {
        return this.value;
    }

    public Path<?> getPath() {
        return this.path;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public Class<?> getType() {
        return this.type;
    }

    public boolean isStartsWith() {
        return this.startsWith;
    }

    public boolean isEndsWith() {
        return this.endsWith;
    }

    public SearchCriteria() {
    }

    public SearchCriteria(boolean exists, String key, SearchOp op, String value, Path<?> path, boolean isArray, Class<?> type, boolean startsWith, boolean endsWith) {
        this.exists = exists;
        this.key = key;
        this.op = op;
        this.value = value;
        this.path = path;
        this.isArray = isArray;
        this.type = type;
        this.startsWith = startsWith;
        this.endsWith = endsWith;
    }

    public static class SearchCriteriaBuilder {
        private boolean exists;
        private String key;
        private SearchOp op;
        private String value;
        private Root<?> root;
        private static final String VALUE_PATTERN = "((?<!\\\\)\\*?)(.+?)((?<!\\\\)\\*?)$";
        private static final Pattern valuePattern = Pattern.compile("((?<!\\\\)\\*?)(.+?)((?<!\\\\)\\*?)$");

        SearchCriteriaBuilder() {
        }

        public SearchCriteriaBuilder exists(boolean exists) {
            this.exists = exists;
            return this;
        }

        public SearchCriteriaBuilder key(String key) {
            this.key = key;
            return this;
        }

        public SearchCriteriaBuilder op(SearchOp op) {
            this.op = op;
            return this;
        }

        public SearchCriteriaBuilder value(String value) {
            this.value = value;
            return this;
        }

        public SearchCriteriaBuilder root(Root<?> root) {
            this.root = root;
            return this;
        }

        public SearchCriteria build() {
            Class type;
            boolean isArray = false;
            boolean startsWith = false;
            boolean endsWith = false;
            String fieldName = this.getFieldName(this.key);
            Path<?> path = this.getPath(this.root, this.key);
            Class clazz = type = path != null ? path.get(fieldName).getJavaType() : String.class;
            if (this.value != null) {
                String[] values;
                this.value = StringUtils.trimToNull((String)this.value.replaceAll("^\"|^'|\"$|'$", "").replace("\\\"", "\"").replace("\\'", "'"));
                Matcher matcher = valuePattern.matcher(URLDecoder.decode(StringUtils.trimToNull((String)this.value), StandardCharsets.UTF_8));
                if (matcher.matches()) {
                    endsWith = "*".equals(matcher.group(1));
                    this.value = matcher.group(2);
                    startsWith = "*".equals(matcher.group(3));
                }
                isArray = (values = this.value.split("(?<!\\\\),")).length > 1;
            }
            return new SearchCriteria(this.exists, fieldName, this.op, this.value, path, isArray, type, startsWith, endsWith);
        }

        private Path<?> getPath(Root<?> root, String key) {
            if (StringUtils.isBlank((CharSequence)key)) {
                return root;
            }
            String[] keyArray = StringUtils.split((String)key, (String)".");
            if (keyArray.length <= 1) {
                return root;
            }
            String[] keyList = Arrays.copyOf(keyArray, keyArray.length - 1);
            Root<?> path = root;
            for (String k : keyList) {
                path = this.getPath((Path<?>)path, k);
            }
            return path;
        }

        private Path<?> getPath(Path<?> path, String k) {
            if (Collection.class.isAssignableFrom(path.get(k).getJavaType())) {
                From current = (From)path;
                return current.join(k, JoinType.LEFT);
            }
            return path.get(k);
        }

        private String getFieldName(String key) {
            List<String> keys = Arrays.asList(StringUtils.split((String)key, (String)"."));
            return keys.get(keys.size() - 1);
        }
    }
}

