/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa;

import app.commerceio.spring.data.search.SearchOp;
import app.commerceio.spring.data.search.jpa.SearchCriteria;
import app.commerceio.spring.data.search.jpa.parser.PredicateBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;

public class SpecificationImpl<T>
implements Specification<T> {
    private final boolean exists;
    private final String key;
    private final SearchOp op;
    private final String value;

    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder criteriaBuilder) {
        SearchCriteria searchCriteria = SearchCriteria.builder().exists(this.exists).key(this.key).op(this.op).value(this.value).root(root).build();
        switch (searchCriteria.getOp()) {
            case EQ: {
                return this.eq(searchCriteria, criteriaBuilder);
            }
            case NE: {
                return this.ne(searchCriteria, criteriaBuilder);
            }
            case GT: {
                return this.gt(searchCriteria, criteriaBuilder);
            }
            case GE: {
                return this.ge(searchCriteria, criteriaBuilder);
            }
            case LT: {
                return this.lt(searchCriteria, criteriaBuilder);
            }
            case LE: {
                return this.le(searchCriteria, criteriaBuilder);
            }
        }
        return this.exists(searchCriteria, criteriaBuilder);
    }

    private Predicate exists(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        if (searchCriteria.isExists()) {
            return criteriaBuilder.isNotNull((Expression)searchCriteria.getPath().get(searchCriteria.getKey()));
        }
        return criteriaBuilder.isNull((Expression)searchCriteria.getPath().get(searchCriteria.getKey()));
    }

    private Predicate eq(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        if (searchCriteria.isArray()) {
            List<String> values = Stream.of(this.getValues(searchCriteria.getValue())).map(this::cleanValue).collect(Collectors.toList());
            return PredicateBuilder.builder(searchCriteria.getType()).in(searchCriteria.getPath(), searchCriteria.getKey(), values, criteriaBuilder);
        }
        String cleanValue = this.cleanValue(searchCriteria.getValue());
        if (searchCriteria.isStartsWith() || searchCriteria.isEndsWith()) {
            return PredicateBuilder.builder(searchCriteria.getType()).like(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, searchCriteria.isStartsWith(), searchCriteria.isEndsWith(), criteriaBuilder);
        }
        return PredicateBuilder.builder(searchCriteria.getType()).eq(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, criteriaBuilder);
    }

    private Predicate ne(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        if (searchCriteria.isArray()) {
            List<String> values = Stream.of(this.getValues(searchCriteria.getValue())).map(this::cleanValue).collect(Collectors.toList());
            return PredicateBuilder.builder(searchCriteria.getType()).nin(searchCriteria.getPath(), searchCriteria.getKey(), values, criteriaBuilder);
        }
        String cleanValue = this.cleanValue(searchCriteria.getValue());
        if (searchCriteria.isStartsWith() || searchCriteria.isEndsWith()) {
            return PredicateBuilder.builder(searchCriteria.getType()).nlike(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, searchCriteria.isStartsWith(), searchCriteria.isEndsWith(), criteriaBuilder);
        }
        return PredicateBuilder.builder(searchCriteria.getType()).ne(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, criteriaBuilder);
    }

    private Predicate gt(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        String cleanValue = this.cleanValue(searchCriteria.getValue());
        return PredicateBuilder.builder(searchCriteria.getType()).gt(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, criteriaBuilder);
    }

    private Predicate ge(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        String cleanValue = this.cleanValue(searchCriteria.getValue());
        return PredicateBuilder.builder(searchCriteria.getType()).ge(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, criteriaBuilder);
    }

    private Predicate lt(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        String cleanValue = this.cleanValue(searchCriteria.getValue());
        return PredicateBuilder.builder(searchCriteria.getType()).lt(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, criteriaBuilder);
    }

    private Predicate le(SearchCriteria searchCriteria, CriteriaBuilder criteriaBuilder) {
        String cleanValue = this.cleanValue(searchCriteria.getValue());
        return PredicateBuilder.builder(searchCriteria.getType()).le(searchCriteria.getPath(), searchCriteria.getKey(), cleanValue, criteriaBuilder);
    }

    private String[] getValues(String value) {
        return value.split("(?<!\\\\),");
    }

    private String cleanValue(String value) {
        return value.replace("\\,", ",").replace("\\*", "*");
    }

    public static <T> SpecificationImplBuilder<T> builder() {
        return new SpecificationImplBuilder();
    }

    public SpecificationImpl(boolean exists, String key, SearchOp op, String value) {
        this.exists = exists;
        this.key = key;
        this.op = op;
        this.value = value;
    }

    public static class SpecificationImplBuilder<T> {
        private boolean exists;
        private String key;
        private SearchOp op;
        private String value;

        SpecificationImplBuilder() {
        }

        public SpecificationImplBuilder<T> exists(boolean exists) {
            this.exists = exists;
            return this;
        }

        public SpecificationImplBuilder<T> key(String key) {
            this.key = key;
            return this;
        }

        public SpecificationImplBuilder<T> op(SearchOp op) {
            this.op = op;
            return this;
        }

        public SpecificationImplBuilder<T> value(String value) {
            this.value = value;
            return this;
        }

        public SpecificationImpl<T> build() {
            return new SpecificationImpl(this.exists, this.key, this.op, this.value);
        }

        public String toString() {
            return "SpecificationImpl.SpecificationImplBuilder(exists=" + this.exists + ", key=" + this.key + ", op=" + this.op + ", value=" + this.value + ")";
        }
    }
}

