/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa.parser;

import app.commerceio.spring.data.search.jpa.parser.PredicateBuilder;
import java.math.BigDecimal;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class BigDecimalPredicateBuilder
implements PredicateBuilder<BigDecimal> {
    @Override
    public BigDecimal parse(String value) {
        return BigDecimal.valueOf(Double.parseDouble(value));
    }

    @Override
    public Predicate gt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        BigDecimal bigDecimal = this.parse(value);
        return criteriaBuilder.greaterThan((Expression)path.get(key), (Comparable)bigDecimal);
    }

    @Override
    public Predicate ge(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        BigDecimal bigDecimal = this.parse(value);
        return criteriaBuilder.greaterThanOrEqualTo((Expression)path.get(key), (Comparable)bigDecimal);
    }

    @Override
    public Predicate lt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        BigDecimal bigDecimal = this.parse(value);
        return criteriaBuilder.lessThan((Expression)path.get(key), (Comparable)bigDecimal);
    }

    @Override
    public Predicate le(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        BigDecimal bigDecimal = this.parse(value);
        return criteriaBuilder.lessThanOrEqualTo((Expression)path.get(key), (Comparable)bigDecimal);
    }
}

