/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa.parser;

import app.commerceio.spring.data.search.jpa.parser.PredicateBuilder;
import java.time.LocalDate;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class LocalDatePredicateBuilder
implements PredicateBuilder<LocalDate> {
    @Override
    public LocalDate parse(String value) {
        try {
            return LocalDate.parse(value);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    public Predicate gt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDate localDate = this.parse(value);
        return criteriaBuilder.greaterThan((Expression)path.get(key), (Comparable)localDate);
    }

    @Override
    public Predicate ge(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDate localDate = this.parse(value);
        return criteriaBuilder.greaterThanOrEqualTo((Expression)path.get(key), (Comparable)localDate);
    }

    @Override
    public Predicate lt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDate localDate = this.parse(value);
        return criteriaBuilder.lessThan((Expression)path.get(key), (Comparable)localDate);
    }

    @Override
    public Predicate le(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDate localDate = this.parse(value);
        return criteriaBuilder.lessThanOrEqualTo((Expression)path.get(key), (Comparable)localDate);
    }
}

