/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa.parser;

import app.commerceio.spring.data.search.jpa.parser.PredicateBuilder;
import java.time.LocalDateTime;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class LocalDateTimePredicateBuilder
implements PredicateBuilder<LocalDateTime> {
    @Override
    public LocalDateTime parse(String value) {
        try {
            return LocalDateTime.parse(value);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    public Predicate gt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDateTime localDateTime = this.parse(value);
        return criteriaBuilder.greaterThan((Expression)path.get(key), (Comparable)localDateTime);
    }

    @Override
    public Predicate ge(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDateTime localDateTime = this.parse(value);
        return criteriaBuilder.greaterThanOrEqualTo((Expression)path.get(key), (Comparable)localDateTime);
    }

    @Override
    public Predicate lt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDateTime localDateTime = this.parse(value);
        return criteriaBuilder.lessThan((Expression)path.get(key), (Comparable)localDateTime);
    }

    @Override
    public Predicate le(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalDateTime localDateTime = this.parse(value);
        return criteriaBuilder.lessThanOrEqualTo((Expression)path.get(key), (Comparable)localDateTime);
    }
}

