/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa.parser;

import app.commerceio.spring.data.search.jpa.parser.PredicateBuilder;
import java.time.LocalTime;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class LocalTimePredicateBuilder
implements PredicateBuilder<LocalTime> {
    @Override
    public LocalTime parse(String value) {
        try {
            return LocalTime.parse(value);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(exception);
        }
    }

    @Override
    public Predicate gt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalTime localTime = this.parse(value);
        return criteriaBuilder.greaterThan((Expression)path.get(key), (Comparable)localTime);
    }

    @Override
    public Predicate ge(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalTime localTime = this.parse(value);
        return criteriaBuilder.greaterThanOrEqualTo((Expression)path.get(key), (Comparable)localTime);
    }

    @Override
    public Predicate lt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalTime localTime = this.parse(value);
        return criteriaBuilder.lessThan((Expression)path.get(key), (Comparable)localTime);
    }

    @Override
    public Predicate le(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        LocalTime localTime = this.parse(value);
        return criteriaBuilder.lessThanOrEqualTo((Expression)path.get(key), (Comparable)localTime);
    }
}

