/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa.parser;

import app.commerceio.spring.data.search.jpa.LikePattern;
import app.commerceio.spring.data.search.jpa.parser.BigDecimalPredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.BooleanPredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.DefaultPredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.LocalDatePredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.LocalDateTimePredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.LocalTimePredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.NumberPredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.OffsetDateTimePredicateBuilder;
import app.commerceio.spring.data.search.jpa.parser.OffsetTimePredicateBuilder;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public interface PredicateBuilder<T> {
    public T parse(String var1);

    public static PredicateBuilder<?> builder(Class<?> type) {
        if (LocalDate.class.equals(type)) {
            return new LocalDatePredicateBuilder();
        }
        if (LocalDateTime.class.equals(type)) {
            return new LocalDateTimePredicateBuilder();
        }
        if (OffsetDateTime.class.equals(type)) {
            return new OffsetDateTimePredicateBuilder();
        }
        if (LocalTime.class.equals(type)) {
            return new LocalTimePredicateBuilder();
        }
        if (OffsetTime.class.equals(type)) {
            return new OffsetTimePredicateBuilder();
        }
        if (Boolean.class.equals(type) || Boolean.TYPE.equals(type)) {
            return new BooleanPredicateBuilder();
        }
        if (BigDecimal.class.equals(type)) {
            return new BigDecimalPredicateBuilder();
        }
        if (Number.class.isAssignableFrom(type) || Double.TYPE.equals(type) || Integer.TYPE.equals(type) || Long.TYPE.equals(type) || Float.TYPE.equals(type)) {
            return new NumberPredicateBuilder();
        }
        return new DefaultPredicateBuilder();
    }

    default public Predicate eq(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.equal((Expression)path.get(key), this.parse(value));
    }

    default public Predicate ne(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.notEqual((Expression)path.get(key), this.parse(value));
    }

    default public Predicate like(Path<?> path, String key, String value, boolean startsWith, boolean endsWith, CriteriaBuilder criteriaBuilder) {
        String likeValue = MessageFormat.format(LikePattern.pattern(startsWith, endsWith).getPattern(), value);
        return criteriaBuilder.like((Expression)path.get(key), likeValue);
    }

    default public Predicate nlike(Path<?> path, String key, String value, boolean startsWith, boolean endsWith, CriteriaBuilder criteriaBuilder) {
        String likeValue = MessageFormat.format(LikePattern.pattern(startsWith, endsWith).getPattern(), value);
        return criteriaBuilder.notLike((Expression)path.get(key), likeValue);
    }

    default public Predicate gt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThan((Expression)path.get(key), (Comparable)((Object)value));
    }

    default public Predicate ge(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.greaterThanOrEqualTo((Expression)path.get(key), (Comparable)((Object)value));
    }

    default public Predicate lt(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.lessThan((Expression)path.get(key), (Comparable)((Object)value));
    }

    default public Predicate le(Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.lessThanOrEqualTo((Expression)path.get(key), (Comparable)((Object)value));
    }

    default public Predicate in(Path<?> path, String key, List<String> values, CriteriaBuilder criteriaBuilder) {
        CriteriaBuilder.In in = criteriaBuilder.in((Expression)path.get(key));
        values.stream().map(this::parse).forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
        return in;
    }

    default public Predicate nin(Path<?> path, String key, List<String> values, CriteriaBuilder criteriaBuilder) {
        return criteriaBuilder.not((Expression)this.in(path, key, values, criteriaBuilder));
    }
}

