/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa;

import app.commerceio.spring.data.search.Mapper;
import app.commerceio.spring.data.search.jpa.SearchBuilder;
import app.commerceio.spring.data.search.jpa.SearchRepository;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class SearchRepositoryImpl<T, I extends Serializable>
extends SimpleJpaRepository<T, I>
implements SearchRepository<T, I> {
    private final SearchBuilder searchBuilder = new SearchBuilder();

    public SearchRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    @Override
    public Page<T> findAll(String search, Pageable pageable) {
        return this.findAll(search, pageable, (Mapper)Mapper.flatMapper().build());
    }

    @Override
    public Page<T> findAll(String search, Pageable pageable, Mapper mapper) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return this.findAll(pageable);
        }
        Specification criteria = this.searchBuilder.parse(search, mapper);
        return this.findAll(criteria, pageable);
    }
}

