/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa;

import app.commerceio.spring.data.search.LogicalOp;
import app.commerceio.spring.data.search.Mapper;
import app.commerceio.spring.data.search.SearchBaseVisitor;
import app.commerceio.spring.data.search.SearchOp;
import app.commerceio.spring.data.search.SearchParser;
import app.commerceio.spring.data.search.jpa.SpecificationImpl;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.Specification;

public class SearchVisitorImpl<T>
extends SearchBaseVisitor<Specification<T>> {
    private static final String KEY_PATTERN = "(!?)(.*)";
    private static final Pattern keyPattern = Pattern.compile("(!?)(.*)");
    private final Mapper mapper;

    public Specification<T> visitInput(SearchParser.InputContext ctx) {
        return (Specification)super.visit((ParseTree)(ctx != null ? ctx.search() : null));
    }

    public Specification<T> visitOpSearch(SearchParser.OpSearchContext ctx) {
        Specification left = (Specification)this.visit((ParseTree)(ctx != null ? ctx.left : null));
        Specification right = (Specification)this.visit((ParseTree)(ctx != null ? ctx.right : null));
        String logicalOp = null;
        if (ctx != null) {
            logicalOp = ctx.logicalOp != null ? ctx.logicalOp.getText() : null;
        }
        switch (LogicalOp.logicalOp(logicalOp)) {
            case OR: {
                return this.or(left, right);
            }
        }
        return this.and(left, right);
    }

    private Specification<T> and(Specification<T> left, Specification<T> right) {
        if (left == null) {
            return right;
        }
        return left.and(right);
    }

    private Specification<T> or(Specification<T> left, Specification<T> right) {
        if (left == null) {
            return right;
        }
        return left.or(right);
    }

    public Specification<T> visitAtomSearch(SearchParser.AtomSearchContext ctx) {
        return (Specification)super.visit((ParseTree)(ctx != null ? ctx.criteria() : null));
    }

    public Specification<T> visitPrioritySearch(SearchParser.PrioritySearchContext ctx) {
        return (Specification)super.visit((ParseTree)(ctx != null ? ctx.search() : null));
    }

    public Specification<T> visitCriteria(SearchParser.CriteriaContext ctx) {
        String key = ctx.key().getText();
        String op = ctx.op() != null ? ctx.op().getText() : null;
        String value = ctx.value() != null ? StringUtils.trimToNull((String)ctx.value().getText().replaceAll("^\"|^'|\"$|'$", "").replace("\\\"", "\"").replace("\\'", "'")) : null;
        SearchOp searchOp = SearchOp.searchOp((String)StringUtils.trimToEmpty((String)op));
        Matcher matcher = keyPattern.matcher(URLDecoder.decode(StringUtils.trimToNull((String)key), StandardCharsets.UTF_8));
        boolean matches = matcher.matches();
        String from = matches ? matcher.group(2) : null;
        Mapper.MappingEntry mappingEntry = this.mapper != null ? this.mapper.mappingEntry(from) : Mapper.MappingEntry.builder().key(from).build();
        return SpecificationImpl.builder().exists(matches && StringUtils.isEmpty((CharSequence)matcher.group(1))).key(mappingEntry.getKey()).op(searchOp).value(mappingEntry.value(value)).build();
    }

    SearchVisitorImpl(Mapper mapper) {
        this.mapper = mapper;
    }

    public static <T> SearchVisitorImplBuilder<T> builder() {
        return new SearchVisitorImplBuilder();
    }

    public static class SearchVisitorImplBuilder<T> {
        private Mapper mapper;

        SearchVisitorImplBuilder() {
        }

        public SearchVisitorImplBuilder<T> mapper(Mapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public SearchVisitorImpl<T> build() {
            return new SearchVisitorImpl(this.mapper);
        }

        public String toString() {
            return "SearchVisitorImpl.SearchVisitorImplBuilder(mapper=" + this.mapper + ")";
        }
    }
}

