/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.jpa.parser;

import app.commerceio.spring.data.search.jpa.parser.PredicateBuilder;
import java.math.BigDecimal;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;

public class BigDecimalPredicateBuilder
implements PredicateBuilder<BigDecimal> {
    @Override
    public BigDecimal parse(Class<?> type, String value) {
        return BigDecimal.valueOf(Double.parseDouble(value));
    }

    @Override
    public Predicate gt(Class<?> type, Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        Object bigDecimal = this.parse((Class)type, value);
        return criteriaBuilder.greaterThan((Expression)path.get(key), (Comparable)bigDecimal);
    }

    @Override
    public Predicate ge(Class<?> type, Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        Object bigDecimal = this.parse((Class)type, value);
        return criteriaBuilder.greaterThanOrEqualTo((Expression)path.get(key), (Comparable)bigDecimal);
    }

    @Override
    public Predicate lt(Class<?> type, Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        Object bigDecimal = this.parse((Class)type, value);
        return criteriaBuilder.lessThan((Expression)path.get(key), (Comparable)bigDecimal);
    }

    @Override
    public Predicate le(Class<?> type, Path<?> path, String key, String value, CriteriaBuilder criteriaBuilder) {
        Object bigDecimal = this.parse((Class)type, value);
        return criteriaBuilder.lessThanOrEqualTo((Expression)path.get(key), (Comparable)bigDecimal);
    }
}

