/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.mongodb;

import app.commerceio.spring.data.search.mongodb.SearchCriteria;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.bson.BsonRegularExpression;
import org.springframework.data.mongodb.core.query.Criteria;

public class CriteriaBuilder {
    private static final String REGEX_WITH_OPTION_PATTERN = "^/(.*)/([gimscxdtu]*)$";
    private static final String REGEX_PATTERN = "^/(.*)$";
    private static final Pattern regExpWithOptionPattern = Pattern.compile("^/(.*)/([gimscxdtu]*)$");
    private static final Pattern regExpPattern = Pattern.compile("^/(.*)$");
    private final SearchCriteria searchCriteria;

    public Criteria toCriteria() {
        Criteria criteria = Criteria.where((String)this.searchCriteria.getKey());
        switch (this.searchCriteria.getOp()) {
            case EQ: {
                return this.eq(this.searchCriteria);
            }
            case NE: {
                return this.ne(this.searchCriteria);
            }
            case GT: {
                return this.gt(this.searchCriteria);
            }
            case GE: {
                return this.gte(this.searchCriteria);
            }
            case LT: {
                return this.lt(this.searchCriteria);
            }
            case LE: {
                return this.lte(this.searchCriteria);
            }
        }
        return criteria.exists(this.searchCriteria.isExists());
    }

    private Criteria eq(SearchCriteria searchCriteria) {
        if (Number.class.equals(searchCriteria.getType())) {
            return this.eqCriteriaForNumberValue(searchCriteria);
        }
        if (Boolean.class.equals(searchCriteria.getType())) {
            return this.eqCriteriaForBooleanValue(searchCriteria);
        }
        if (Instant.class.equals(searchCriteria.getType())) {
            return this.eqCriteriaForInstantValue(searchCriteria);
        }
        return this.eqCriteria(searchCriteria);
    }

    private Criteria ne(SearchCriteria searchCriteria) {
        if (Number.class.equals(searchCriteria.getType())) {
            return this.neCriteriaForNumberValue(searchCriteria);
        }
        if (Boolean.class.equals(searchCriteria.getType())) {
            return this.neCriteriaForBooleanValue(searchCriteria);
        }
        if (Instant.class.equals(searchCriteria.getType())) {
            return this.neCriteriaForInstantValue(searchCriteria);
        }
        return this.neCriteria(searchCriteria);
    }

    private Criteria gt(SearchCriteria searchCriteria) {
        if (Number.class.equals(searchCriteria.getType())) {
            return this.gtCriteriaForNumberValue(searchCriteria);
        }
        if (Boolean.class.equals(searchCriteria.getType())) {
            return this.gtCriteriaForBooleanValue(searchCriteria);
        }
        if (Instant.class.equals(searchCriteria.getType())) {
            return this.gtCriteriaForInstantValue(searchCriteria);
        }
        return this.gtCriteria(searchCriteria);
    }

    private Criteria gte(SearchCriteria searchCriteria) {
        if (Number.class.equals(searchCriteria.getType())) {
            return this.gteCriteriaForNumberValue(searchCriteria);
        }
        if (Boolean.class.equals(searchCriteria.getType())) {
            return this.gteCriteriaForBooleanValue(searchCriteria);
        }
        if (Instant.class.equals(searchCriteria.getType())) {
            return this.gteCriteriaForInstantValue(searchCriteria);
        }
        return this.gteCriteria(searchCriteria);
    }

    private Criteria lt(SearchCriteria searchCriteria) {
        if (Number.class.equals(searchCriteria.getType())) {
            return this.ltCriteriaForNumberValue(searchCriteria);
        }
        if (Boolean.class.equals(searchCriteria.getType())) {
            return this.ltCriteriaForBooleanValue(searchCriteria);
        }
        if (Instant.class.equals(searchCriteria.getType())) {
            return this.ltCriteriaForInstantValue(searchCriteria);
        }
        return this.ltCriteria(searchCriteria);
    }

    private Criteria lte(SearchCriteria searchCriteria) {
        if (Number.class.equals(searchCriteria.getType())) {
            return this.lteCriteriaForNumberValue(searchCriteria);
        }
        if (Boolean.class.equals(searchCriteria.getType())) {
            return this.lteCriteriaForBooleanValue(searchCriteria);
        }
        if (Instant.class.equals(searchCriteria.getType())) {
            return this.lteCriteriaForInstantValue(searchCriteria);
        }
        return this.lteCriteria(searchCriteria);
    }

    private Criteria eqCriteria(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            Object[] values = Stream.of(this.getValues(searchCriteria.getValue())).map(this::cleanValue).toArray();
            return Criteria.where((String)searchCriteria.getKey()).in(values);
        }
        Object value = this.getValue(searchCriteria.getValue());
        return this.eq(searchCriteria.getKey(), value);
    }

    private Criteria neCriteria(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            Object[] values = Stream.of(this.getValues(searchCriteria.getValue())).map(this::cleanValue).toArray();
            return Criteria.where((String)searchCriteria.getKey()).nin(values);
        }
        Object value = this.getValue(searchCriteria.getValue());
        return this.ne(searchCriteria.getKey(), value);
    }

    private Criteria gtCriteria(SearchCriteria searchCriteria) {
        return Criteria.where((String)searchCriteria.getKey()).gt((Object)searchCriteria.getValue());
    }

    private Criteria gteCriteria(SearchCriteria searchCriteria) {
        return Criteria.where((String)searchCriteria.getKey()).gte((Object)searchCriteria.getValue());
    }

    private Criteria ltCriteria(SearchCriteria searchCriteria) {
        return Criteria.where((String)searchCriteria.getKey()).lt((Object)searchCriteria.getValue());
    }

    private Criteria lteCriteria(SearchCriteria searchCriteria) {
        return Criteria.where((String)searchCriteria.getKey()).lte((Object)searchCriteria.getValue());
    }

    private Criteria eqCriteriaForBooleanValue(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            String[] values = this.getValues(searchCriteria.getValue());
            Object[] stringValues = Stream.of(values).toArray();
            Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).in(stringValues);
            Object[] booleanValues = Stream.of(values).map(this::getBooleanValue).toArray();
            Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).in(booleanValues);
            return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
        }
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).is((Object)searchCriteria.getValue());
        Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).is((Object)this.getBooleanValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
    }

    private Criteria neCriteriaForBooleanValue(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            String[] values = this.getValues(searchCriteria.getValue());
            Object[] stringValues = Stream.of(values).toArray();
            Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).nin(stringValues);
            Object[] booleanValues = Stream.of(values).map(this::getBooleanValue).toArray();
            Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).nin(booleanValues);
            return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
        }
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).ne((Object)searchCriteria.getValue());
        Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).ne((Object)this.getBooleanValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
    }

    private Criteria gtCriteriaForBooleanValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).gt((Object)searchCriteria.getValue());
        Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).gt((Object)this.getBooleanValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
    }

    private Criteria gteCriteriaForBooleanValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).gte((Object)searchCriteria.getValue());
        Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).gte((Object)this.getBooleanValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
    }

    private Criteria ltCriteriaForBooleanValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).lt((Object)searchCriteria.getValue());
        Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).lt((Object)this.getBooleanValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
    }

    private Criteria lteCriteriaForBooleanValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).lte((Object)searchCriteria.getValue());
        Criteria booleanCriteria = Criteria.where((String)searchCriteria.getKey()).lte((Object)this.getBooleanValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, booleanCriteria});
    }

    private Criteria eqCriteriaForNumberValue(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            String[] values = this.getValues(searchCriteria.getValue());
            Object[] stringValues = Stream.of(values).toArray();
            Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).in(stringValues);
            Object[] numberValues = Stream.of(values).map(this::getNumberValue).filter(Objects::nonNull).toArray();
            Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).in(numberValues);
            return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
        }
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).is((Object)searchCriteria.getValue());
        Number number = this.getNumberValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).is((Object)number);
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria neCriteriaForNumberValue(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            String[] values = this.getValues(searchCriteria.getValue());
            Object[] stringValues = Stream.of(values).toArray();
            Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).nin(stringValues);
            Object[] numberValues = Stream.of(values).map(this::getNumberValue).filter(Objects::nonNull).toArray();
            Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).nin(numberValues);
            return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
        }
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).ne((Object)searchCriteria.getValue());
        Number number = this.getNumberValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).ne((Object)number);
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria gtCriteriaForNumberValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).gt((Object)searchCriteria.getValue());
        Number number = this.getNumberValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).gt((Object)(number != null ? number : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria gteCriteriaForNumberValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).gte((Object)searchCriteria.getValue());
        Number number = this.getNumberValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).gte((Object)(number != null ? number : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria ltCriteriaForNumberValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).lt((Object)searchCriteria.getValue());
        Number number = this.getNumberValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).lt((Object)(number != null ? number : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria lteCriteriaForNumberValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).lte((Object)searchCriteria.getValue());
        Number number = this.getNumberValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).lte((Object)(number != null ? number : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria eqCriteriaForInstantValue(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            String[] values = this.getValues(searchCriteria.getValue());
            Object[] stringValues = Stream.of(values).toArray();
            Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).in(stringValues);
            Object[] dateValues = Stream.of(values).map(this::getInstantValue).filter(Objects::nonNull).toArray();
            Criteria dateCriteria = Criteria.where((String)searchCriteria.getKey()).in(dateValues);
            return new Criteria().orOperator(new Criteria[]{stringCriteria, dateCriteria});
        }
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).is((Object)searchCriteria.getValue());
        Criteria dateCriteria = Criteria.where((String)searchCriteria.getKey()).is((Object)this.getInstantValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, dateCriteria});
    }

    private Criteria neCriteriaForInstantValue(SearchCriteria searchCriteria) {
        if (searchCriteria.isArray()) {
            String[] values = this.getValues(searchCriteria.getValue());
            Object[] stringValues = Stream.of(values).toArray();
            Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).nin(stringValues);
            Object[] dateValues = Stream.of(values).map(this::getInstantValue).filter(Objects::nonNull).toArray();
            Criteria dateCriteria = Criteria.where((String)searchCriteria.getKey()).nin(dateValues);
            return new Criteria().orOperator(new Criteria[]{stringCriteria, dateCriteria});
        }
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).ne((Object)searchCriteria.getValue());
        Criteria dateCriteria = Criteria.where((String)searchCriteria.getKey()).ne((Object)this.getInstantValue(searchCriteria.getValue()));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, dateCriteria});
    }

    private Criteria gtCriteriaForInstantValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).gt((Object)searchCriteria.getValue());
        Instant instant = this.getInstantValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).gt((Object)(instant != null ? instant : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria gteCriteriaForInstantValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).gte((Object)searchCriteria.getValue());
        Instant instant = this.getInstantValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).gte((Object)(instant != null ? instant : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria ltCriteriaForInstantValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).lt((Object)searchCriteria.getValue());
        Instant instant = this.getInstantValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).lt((Object)(instant != null ? instant : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria lteCriteriaForInstantValue(SearchCriteria searchCriteria) {
        Criteria stringCriteria = Criteria.where((String)searchCriteria.getKey()).lte((Object)searchCriteria.getValue());
        Instant instant = this.getInstantValue(searchCriteria.getValue());
        Criteria numberCriteria = Criteria.where((String)searchCriteria.getKey()).lte((Object)(instant != null ? instant : stringCriteria));
        return new Criteria().orOperator(new Criteria[]{stringCriteria, numberCriteria});
    }

    private Criteria eq(String key, Object value) {
        Criteria criteria = Criteria.where((String)key);
        if (value instanceof BsonRegularExpression) {
            criteria.regex((BsonRegularExpression)value);
        } else {
            criteria.is(value);
        }
        return criteria;
    }

    private Criteria ne(String key, Object value) {
        Criteria criteria = Criteria.where((String)key);
        if (value instanceof BsonRegularExpression) {
            criteria.not().regex((BsonRegularExpression)value);
        } else {
            criteria.ne(value);
        }
        return criteria;
    }

    private String[] getValues(String value) {
        return value.split("(?<!\\\\),");
    }

    private Number getNumberValue(String value) {
        try {
            return NumberFormat.getInstance().parse(value);
        }
        catch (ParseException ignored) {
            return null;
        }
    }

    private Boolean getBooleanValue(String value) {
        return Boolean.valueOf(value);
    }

    private Instant getInstantValue(String value) {
        try {
            return OffsetDateTime.parse(value).toInstant();
        }
        catch (Exception ignored) {
            return LocalDate.parse(value).atStartOfDay().atOffset(ZoneOffset.UTC).toInstant();
        }
    }

    private Object getValue(String value) {
        Matcher matcherRegExpWithOption = regExpWithOptionPattern.matcher(value);
        if (matcherRegExpWithOption.matches()) {
            return new BsonRegularExpression(matcherRegExpWithOption.group(1), matcherRegExpWithOption.group(2));
        }
        Matcher matcherRegExp = regExpPattern.matcher(value);
        if (matcherRegExp.matches()) {
            return new BsonRegularExpression(matcherRegExp.group(1));
        }
        return this.cleanValue(value);
    }

    private String cleanValue(String value) {
        return value.replace("\\,", ",");
    }

    public static CriteriaBuilderBuilder builder() {
        return new CriteriaBuilderBuilder();
    }

    public CriteriaBuilder(SearchCriteria searchCriteria) {
        this.searchCriteria = searchCriteria;
    }

    public static class CriteriaBuilderBuilder {
        private SearchCriteria searchCriteria;

        CriteriaBuilderBuilder() {
        }

        public CriteriaBuilderBuilder searchCriteria(SearchCriteria searchCriteria) {
            this.searchCriteria = searchCriteria;
            return this;
        }

        public CriteriaBuilder build() {
            return new CriteriaBuilder(this.searchCriteria);
        }

        public String toString() {
            return "CriteriaBuilder.CriteriaBuilderBuilder(searchCriteria=" + this.searchCriteria + ")";
        }
    }
}

