/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.mongodb;

import app.commerceio.spring.data.search.Mapper;
import app.commerceio.spring.data.search.SearchLexer;
import app.commerceio.spring.data.search.SearchParser;
import app.commerceio.spring.data.search.mongodb.SearchVisitorImpl;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;

public class SearchBuilder {
    public Criteria parse(String search) {
        return this.parse(search, (Mapper)Mapper.flatMapper().build());
    }

    public Criteria parse(String search, Mapper mapper) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return null;
        }
        SearchVisitorImpl searchVisitor = SearchVisitorImpl.builder().mapper(mapper).build();
        SearchParser parser = this.getParser(search);
        return (Criteria)searchVisitor.visit((ParseTree)parser.input());
    }

    public Criteria and(Criteria ... criteria) {
        if (criteria == null || criteria.length == 0) {
            return null;
        }
        return new Criteria().andOperator(criteria);
    }

    public Criteria or(Criteria ... criteria) {
        if (criteria == null || criteria.length == 0) {
            return null;
        }
        return new Criteria().orOperator(criteria);
    }

    private SearchParser getParser(String search) {
        SearchLexer lexer = new SearchLexer((CharStream)CharStreams.fromString((String)search));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        return new SearchParser((TokenStream)tokens);
    }
}

