/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.mongodb;

import app.commerceio.spring.data.search.Mapper;
import app.commerceio.spring.data.search.mongodb.SearchBuilder;
import app.commerceio.spring.data.search.mongodb.SearchRepository;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;

public class SearchRepositoryImpl<T, I extends Serializable>
extends SimpleMongoRepository<T, I>
implements SearchRepository<T, I> {
    private final SearchBuilder searchBuilder;
    private final MongoOperations mongoOperations;
    private final MongoEntityInformation<T, I> entityInformation;

    public SearchRepositoryImpl(MongoEntityInformation<T, I> entityInformation, MongoOperations mongoOperations) {
        super(entityInformation, mongoOperations);
        this.entityInformation = entityInformation;
        this.mongoOperations = mongoOperations;
        this.searchBuilder = new SearchBuilder();
    }

    @Override
    public Page<T> findAll(Query query, Pageable pageable) {
        if (query == null) {
            return this.findAll(pageable);
        }
        long total = this.mongoOperations.count(query, this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        List content = this.mongoOperations.find(query.with(pageable), this.entityInformation.getJavaType(), this.entityInformation.getCollectionName());
        return new PageImpl(content, pageable, total);
    }

    @Override
    public Page<T> findAll(Criteria criteria, Pageable pageable) {
        Query query = criteria != null ? Query.query((CriteriaDefinition)criteria) : null;
        return this.findAll(query, pageable);
    }

    @Override
    public Page<T> findAll(String search, Pageable pageable) {
        return this.findAll(search, pageable, (Mapper)Mapper.flatMapper().build());
    }

    @Override
    public Page<T> findAll(String search, Pageable pageable, Mapper mapper) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return this.findAll(pageable);
        }
        Criteria criteria = this.searchBuilder.parse(search, mapper);
        return this.findAll(criteria, pageable);
    }
}

