/*
 * Decompiled with CFR 0.152.
 */
package app.commerceio.spring.data.search.mongodb;

import app.commerceio.spring.data.search.LogicalOp;
import app.commerceio.spring.data.search.Mapper;
import app.commerceio.spring.data.search.SearchBaseVisitor;
import app.commerceio.spring.data.search.SearchOp;
import app.commerceio.spring.data.search.SearchParser;
import app.commerceio.spring.data.search.mongodb.CriteriaBuilder;
import app.commerceio.spring.data.search.mongodb.SearchCriteria;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.query.Criteria;

public class SearchVisitorImpl
extends SearchBaseVisitor<Criteria> {
    private static final String KEY_PATTERN = "(!?)(.*)";
    private static final Pattern keyPattern = Pattern.compile("(!?)(.*)");
    private final Mapper mapper;

    public Criteria visitInput(SearchParser.InputContext ctx) {
        return (Criteria)super.visit((ParseTree)(ctx != null ? ctx.search() : null));
    }

    public Criteria visitOpSearch(SearchParser.OpSearchContext ctx) {
        Criteria right;
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        Criteria left = (Criteria)this.visit((ParseTree)(ctx != null ? ctx.left : null));
        if (left != null) {
            criteriaList.add(left);
        }
        if ((right = (Criteria)this.visit((ParseTree)(ctx != null ? ctx.right : null))) != null) {
            criteriaList.add(right);
        }
        String logicalOp = null;
        if (ctx != null) {
            logicalOp = ctx.logicalOp != null ? ctx.logicalOp.getText() : null;
        }
        switch (LogicalOp.logicalOp(logicalOp)) {
            case OR: {
                return new Criteria().orOperator(criteriaList.toArray(new Criteria[0]));
            }
        }
        return new Criteria().andOperator(criteriaList.toArray(new Criteria[0]));
    }

    public Criteria visitAtomSearch(SearchParser.AtomSearchContext ctx) {
        return (Criteria)super.visit((ParseTree)(ctx != null ? ctx.criteria() : null));
    }

    public Criteria visitPrioritySearch(SearchParser.PrioritySearchContext ctx) {
        return (Criteria)super.visit((ParseTree)(ctx != null ? ctx.search() : null));
    }

    public Criteria visitCriteria(SearchParser.CriteriaContext ctx) {
        String key = ctx.key().getText();
        String op = ctx.op() != null ? ctx.op().getText() : null;
        String value = ctx.value() != null ? ctx.value().getText() : null;
        SearchOp searchOp = SearchOp.searchOp((String)StringUtils.trimToEmpty((String)op));
        Matcher matcher = keyPattern.matcher(URLDecoder.decode(StringUtils.trimToNull((String)key), StandardCharsets.UTF_8));
        boolean matches = matcher.matches();
        String from = matches ? matcher.group(2) : null;
        String to = this.mapper != null ? this.mapper.map(from) : from;
        return this.buildCriteria(SearchCriteria.builder().exists(matches && StringUtils.isEmpty((CharSequence)matcher.group(1))).key(to).op(searchOp).value(value).build());
    }

    private Criteria buildCriteria(SearchCriteria searchCriteria) {
        return CriteriaBuilder.builder().searchCriteria(searchCriteria).build().toCriteria();
    }

    SearchVisitorImpl(Mapper mapper) {
        this.mapper = mapper;
    }

    public static SearchVisitorImplBuilder builder() {
        return new SearchVisitorImplBuilder();
    }

    public static class SearchVisitorImplBuilder {
        private Mapper mapper;

        SearchVisitorImplBuilder() {
        }

        public SearchVisitorImplBuilder mapper(Mapper mapper) {
            this.mapper = mapper;
            return this;
        }

        public SearchVisitorImpl build() {
            return new SearchVisitorImpl(this.mapper);
        }

        public String toString() {
            return "SearchVisitorImpl.SearchVisitorImplBuilder(mapper=" + this.mapper + ")";
        }
    }
}

