/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PostTransferBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferListBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class TransfersBankApi {
    private ApiClient apiClient;

    public TransfersBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public TransfersBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createTransferRequestCreation(PostTransferBankModel postTransferBankModel) throws WebClientResponseException {
        PostTransferBankModel postBody = postTransferBankModel;
        if (postTransferBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postTransferBankModel' when calling createTransfer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TransferBankModel> localVarReturnType = new ParameterizedTypeReference<TransferBankModel>(){};
        return this.apiClient.invokeAPI("/api/transfers", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TransferBankModel> createTransfer(PostTransferBankModel postTransferBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<TransferBankModel> localVarReturnType = new ParameterizedTypeReference<TransferBankModel>(){};
        return this.createTransferRequestCreation(postTransferBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TransferBankModel>> createTransferWithHttpInfo(PostTransferBankModel postTransferBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<TransferBankModel> localVarReturnType = new ParameterizedTypeReference<TransferBankModel>(){};
        return this.createTransferRequestCreation(postTransferBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getTransferRequestCreation(String transferGuid) throws WebClientResponseException {
        Object postBody = null;
        if (transferGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'transferGuid' when calling getTransfer", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("transfer_guid", transferGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TransferBankModel> localVarReturnType = new ParameterizedTypeReference<TransferBankModel>(){};
        return this.apiClient.invokeAPI("/api/transfers/{transfer_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TransferBankModel> getTransfer(String transferGuid) throws WebClientResponseException {
        ParameterizedTypeReference<TransferBankModel> localVarReturnType = new ParameterizedTypeReference<TransferBankModel>(){};
        return this.getTransferRequestCreation(transferGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TransferBankModel>> getTransferWithHttpInfo(String transferGuid) throws WebClientResponseException {
        ParameterizedTypeReference<TransferBankModel> localVarReturnType = new ParameterizedTypeReference<TransferBankModel>(){};
        return this.getTransferRequestCreation(transferGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listTransfersRequestCreation(BigInteger page, BigInteger perPage, String guid, String transferType, String bankGuid, String customerGuid, String accountGuid, String state, String side, String label, String createdAtGte, String createdAtLt, String updatedAtGte, String updatedAtLt) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "transfer_type", transferType));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "account_guid", accountGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "side", side));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "label", label));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "created_at_gte", createdAtGte));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "created_at_lt", createdAtLt));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "updated_at_gte", updatedAtGte));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "updated_at_lt", updatedAtLt));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<TransferListBankModel> localVarReturnType = new ParameterizedTypeReference<TransferListBankModel>(){};
        return this.apiClient.invokeAPI("/api/transfers", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<TransferListBankModel> listTransfers(BigInteger page, BigInteger perPage, String guid, String transferType, String bankGuid, String customerGuid, String accountGuid, String state, String side, String label, String createdAtGte, String createdAtLt, String updatedAtGte, String updatedAtLt) throws WebClientResponseException {
        ParameterizedTypeReference<TransferListBankModel> localVarReturnType = new ParameterizedTypeReference<TransferListBankModel>(){};
        return this.listTransfersRequestCreation(page, perPage, guid, transferType, bankGuid, customerGuid, accountGuid, state, side, label, createdAtGte, createdAtLt, updatedAtGte, updatedAtLt).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<TransferListBankModel>> listTransfersWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String transferType, String bankGuid, String customerGuid, String accountGuid, String state, String side, String label, String createdAtGte, String createdAtLt, String updatedAtGte, String updatedAtLt) throws WebClientResponseException {
        ParameterizedTypeReference<TransferListBankModel> localVarReturnType = new ParameterizedTypeReference<TransferListBankModel>(){};
        return this.listTransfersRequestCreation(page, perPage, guid, transferType, bankGuid, customerGuid, accountGuid, state, side, label, createdAtGte, createdAtLt, updatedAtGte, updatedAtLt).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

