/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"type", "state", "failure_codes"})
@JsonTypeName(value="VerificationCheck")
public class VerificationCheckBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private String type;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_FAILURE_CODES = "failure_codes";
    private List<String> failureCodes = null;

    public VerificationCheckBankModel type(String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The type of verification check; one of business_watchlists, business_verification, business_tax_id_verification, person_attested, person_tax_id_attested, person_watchlists, person_verification, person_authentication, person_gov_id_verification, or person_tax_id_verification.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(String type) {
        this.type = type;
    }

    public VerificationCheckBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The state of the verification check; one of passed, failed, expired, or invalidated.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setState(String state) {
        this.state = state;
    }

    public VerificationCheckBankModel failureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
        return this;
    }

    public VerificationCheckBankModel addFailureCodesItem(String failureCodesItem) {
        if (this.failureCodes == null) {
            this.failureCodes = new ArrayList<String>();
        }
        this.failureCodes.add(failureCodesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason codes explaining the outcome.")
    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getFailureCodes() {
        return this.failureCodes;
    }

    @JsonProperty(value="failure_codes")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCodes(List<String> failureCodes) {
        this.failureCodes = failureCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VerificationCheckBankModel verificationCheck = (VerificationCheckBankModel)o;
        return Objects.equals(this.type, verificationCheck.type) && Objects.equals(this.state, verificationCheck.state) && Objects.equals(this.failureCodes, verificationCheck.failureCodes);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.state, this.failureCodes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VerificationCheckBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    failureCodes: ").append(this.toIndentedString(this.failureCodes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

