/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.TransferDestinationAccountBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferSourceAccountBankModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "transfer_type", "bank_guid", "customer_guid", "quote_guid", "external_bank_account_guid", "asset", "side", "state", "failure_code", "amount", "estimated_amount", "fee", "estimated_network_fee", "network_fee", "network_fee_asset", "network_fee_liability_amount", "network_fee_liability_amount_asset", "txn_hash", "reference_transfer_guid", "source_account", "destination_account", "created_at", "updated_at", "transfer_details", "payment_rail", "labels"})
@JsonTypeName(value="Transfer")
public class TransferBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
    private String transferType;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private String externalBankAccountGuid;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_SIDE = "side";
    private String side;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private String failureCode;
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount;
    public static final String JSON_PROPERTY_ESTIMATED_AMOUNT = "estimated_amount";
    private BigInteger estimatedAmount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private BigInteger fee;
    public static final String JSON_PROPERTY_ESTIMATED_NETWORK_FEE = "estimated_network_fee";
    private BigInteger estimatedNetworkFee;
    public static final String JSON_PROPERTY_NETWORK_FEE = "network_fee";
    private BigInteger networkFee;
    public static final String JSON_PROPERTY_NETWORK_FEE_ASSET = "network_fee_asset";
    private String networkFeeAsset;
    public static final String JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT = "network_fee_liability_amount";
    private BigInteger networkFeeLiabilityAmount;
    public static final String JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT_ASSET = "network_fee_liability_amount_asset";
    private String networkFeeLiabilityAmountAsset;
    public static final String JSON_PROPERTY_TXN_HASH = "txn_hash";
    private String txnHash;
    public static final String JSON_PROPERTY_REFERENCE_TRANSFER_GUID = "reference_transfer_guid";
    private String referenceTransferGuid;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT = "source_account";
    private TransferSourceAccountBankModel sourceAccount;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT = "destination_account";
    private TransferDestinationAccountBankModel destinationAccount;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSFER_DETAILS = "transfer_details";
    private Object transferDetails;
    public static final String JSON_PROPERTY_PAYMENT_RAIL = "payment_rail";
    private String paymentRail;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;

    public TransferBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the transfer.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public TransferBankModel transferType(String transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of transfer; one of funding, book, crypto, instant_funding, funding_return, or crypto_return.")
    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferType() {
        return this.transferType;
    }

    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public TransferBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated bank's identifier.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public TransferBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated customer's identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public TransferBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public TransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated external bank account's identifier.")
    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExternalBankAccountGuid() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public TransferBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset the transfer is related to, e.g., USD.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public TransferBankModel side(String side) {
        this.side = side;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction of the quote; one of deposit or withdrawal.")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSide(String side) {
        this.side = side;
    }

    public TransferBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the transfer; one of storing, pending, reviewing, completed, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public TransferBankModel failureCode(String failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed transfers.")
    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailureCode() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public TransferBankModel amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The actual amount in base units of the asset.")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public TransferBankModel estimatedAmount(BigInteger estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The estimated amount in base units of the asset.")
    @JsonProperty(value="estimated_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getEstimatedAmount() {
        return this.estimatedAmount;
    }

    @JsonProperty(value="estimated_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedAmount(BigInteger estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    public TransferBankModel fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee associated with the transfer.")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public TransferBankModel estimatedNetworkFee(BigInteger estimatedNetworkFee) {
        this.estimatedNetworkFee = estimatedNetworkFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The estimated network fee in base units of network_fee_asset. Only present on `crypto` transfers.")
    @JsonProperty(value="estimated_network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getEstimatedNetworkFee() {
        return this.estimatedNetworkFee;
    }

    @JsonProperty(value="estimated_network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedNetworkFee(BigInteger estimatedNetworkFee) {
        this.estimatedNetworkFee = estimatedNetworkFee;
    }

    public TransferBankModel networkFee(BigInteger networkFee) {
        this.networkFee = networkFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The actual network fee in base units of network_fee_asset. Only present on `crypto` transfers that have successfully completed.")
    @JsonProperty(value="network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getNetworkFee() {
        return this.networkFee;
    }

    @JsonProperty(value="network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFee(BigInteger networkFee) {
        this.networkFee = networkFee;
    }

    public TransferBankModel networkFeeAsset(String networkFeeAsset) {
        this.networkFeeAsset = networkFeeAsset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code of the network fee. Only present on `crypto` transfers that have successfully completed.")
    @JsonProperty(value="network_fee_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkFeeAsset() {
        return this.networkFeeAsset;
    }

    @JsonProperty(value="network_fee_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFeeAsset(String networkFeeAsset) {
        this.networkFeeAsset = networkFeeAsset;
    }

    public TransferBankModel networkFeeLiabilityAmount(BigInteger networkFeeLiabilityAmount) {
        this.networkFeeLiabilityAmount = networkFeeLiabilityAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The equivalent fiat network fee in base units of network_fee_liability_amount_asset. Only present on `crypto` transfers that have successfully completed.")
    @JsonProperty(value="network_fee_liability_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getNetworkFeeLiabilityAmount() {
        return this.networkFeeLiabilityAmount;
    }

    @JsonProperty(value="network_fee_liability_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFeeLiabilityAmount(BigInteger networkFeeLiabilityAmount) {
        this.networkFeeLiabilityAmount = networkFeeLiabilityAmount;
    }

    public TransferBankModel networkFeeLiabilityAmountAsset(String networkFeeLiabilityAmountAsset) {
        this.networkFeeLiabilityAmountAsset = networkFeeLiabilityAmountAsset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fiat asset the network_fee_liability_amount is denominated in. Only present on `crypto` transfers that have successfully completed.")
    @JsonProperty(value="network_fee_liability_amount_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkFeeLiabilityAmountAsset() {
        return this.networkFeeLiabilityAmountAsset;
    }

    @JsonProperty(value="network_fee_liability_amount_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFeeLiabilityAmountAsset(String networkFeeLiabilityAmountAsset) {
        this.networkFeeLiabilityAmountAsset = networkFeeLiabilityAmountAsset;
    }

    public TransferBankModel txnHash(String txnHash) {
        this.txnHash = txnHash;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hash of the blockchain transaction")
    @JsonProperty(value="txn_hash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTxnHash() {
        return this.txnHash;
    }

    @JsonProperty(value="txn_hash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTxnHash(String txnHash) {
        this.txnHash = txnHash;
    }

    public TransferBankModel referenceTransferGuid(String referenceTransferGuid) {
        this.referenceTransferGuid = referenceTransferGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The guid of the related transfer. Only present on `funding_return` transfers.")
    @JsonProperty(value="reference_transfer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getReferenceTransferGuid() {
        return this.referenceTransferGuid;
    }

    @JsonProperty(value="reference_transfer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReferenceTransferGuid(String referenceTransferGuid) {
        this.referenceTransferGuid = referenceTransferGuid;
    }

    public TransferBankModel sourceAccount(TransferSourceAccountBankModel sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="source_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferSourceAccountBankModel getSourceAccount() {
        return this.sourceAccount;
    }

    @JsonProperty(value="source_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSourceAccount(TransferSourceAccountBankModel sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public TransferBankModel destinationAccount(TransferDestinationAccountBankModel destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonProperty(value="destination_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public TransferDestinationAccountBankModel getDestinationAccount() {
        return this.destinationAccount;
    }

    @JsonProperty(value="destination_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDestinationAccount(TransferDestinationAccountBankModel destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public TransferBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TransferBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TransferBankModel transferDetails(Object transferDetails) {
        this.transferDetails = transferDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The raw details on the transfer from the bank.")
    @JsonProperty(value="transfer_details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Object getTransferDetails() {
        return this.transferDetails;
    }

    @JsonProperty(value="transfer_details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferDetails(Object transferDetails) {
        this.transferDetails = transferDetails;
    }

    public TransferBankModel paymentRail(String paymentRail) {
        this.paymentRail = paymentRail;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rail the payment was done on. One of: ach, eft, wire, rtp")
    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPaymentRail() {
        return this.paymentRail;
    }

    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPaymentRail(String paymentRail) {
        this.paymentRail = paymentRail;
    }

    public TransferBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public TransferBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the transfer.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferBankModel transfer = (TransferBankModel)o;
        return Objects.equals(this.guid, transfer.guid) && Objects.equals(this.transferType, transfer.transferType) && Objects.equals(this.bankGuid, transfer.bankGuid) && Objects.equals(this.customerGuid, transfer.customerGuid) && Objects.equals(this.quoteGuid, transfer.quoteGuid) && Objects.equals(this.externalBankAccountGuid, transfer.externalBankAccountGuid) && Objects.equals(this.asset, transfer.asset) && Objects.equals(this.side, transfer.side) && Objects.equals(this.state, transfer.state) && Objects.equals(this.failureCode, transfer.failureCode) && Objects.equals(this.amount, transfer.amount) && Objects.equals(this.estimatedAmount, transfer.estimatedAmount) && Objects.equals(this.fee, transfer.fee) && Objects.equals(this.estimatedNetworkFee, transfer.estimatedNetworkFee) && Objects.equals(this.networkFee, transfer.networkFee) && Objects.equals(this.networkFeeAsset, transfer.networkFeeAsset) && Objects.equals(this.networkFeeLiabilityAmount, transfer.networkFeeLiabilityAmount) && Objects.equals(this.networkFeeLiabilityAmountAsset, transfer.networkFeeLiabilityAmountAsset) && Objects.equals(this.txnHash, transfer.txnHash) && Objects.equals(this.referenceTransferGuid, transfer.referenceTransferGuid) && Objects.equals(this.sourceAccount, transfer.sourceAccount) && Objects.equals(this.destinationAccount, transfer.destinationAccount) && Objects.equals(this.createdAt, transfer.createdAt) && Objects.equals(this.updatedAt, transfer.updatedAt) && Objects.equals(this.transferDetails, transfer.transferDetails) && Objects.equals(this.paymentRail, transfer.paymentRail) && Objects.equals(this.labels, transfer.labels);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.transferType, this.bankGuid, this.customerGuid, this.quoteGuid, this.externalBankAccountGuid, this.asset, this.side, this.state, this.failureCode, this.amount, this.estimatedAmount, this.fee, this.estimatedNetworkFee, this.networkFee, this.networkFeeAsset, this.networkFeeLiabilityAmount, this.networkFeeLiabilityAmountAsset, this.txnHash, this.referenceTransferGuid, this.sourceAccount, this.destinationAccount, this.createdAt, this.updatedAt, this.transferDetails, this.paymentRail, this.labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString(this.transferType)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    side: ").append(this.toIndentedString(this.side)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    estimatedAmount: ").append(this.toIndentedString(this.estimatedAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    estimatedNetworkFee: ").append(this.toIndentedString(this.estimatedNetworkFee)).append("\n");
        sb.append("    networkFee: ").append(this.toIndentedString(this.networkFee)).append("\n");
        sb.append("    networkFeeAsset: ").append(this.toIndentedString(this.networkFeeAsset)).append("\n");
        sb.append("    networkFeeLiabilityAmount: ").append(this.toIndentedString(this.networkFeeLiabilityAmount)).append("\n");
        sb.append("    networkFeeLiabilityAmountAsset: ").append(this.toIndentedString(this.networkFeeLiabilityAmountAsset)).append("\n");
        sb.append("    txnHash: ").append(this.toIndentedString(this.txnHash)).append("\n");
        sb.append("    referenceTransferGuid: ").append(this.toIndentedString(this.referenceTransferGuid)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    destinationAccount: ").append(this.toIndentedString(this.destinationAccount)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    transferDetails: ").append(this.toIndentedString(this.transferDetails)).append("\n");
        sb.append("    paymentRail: ").append(this.toIndentedString(this.paymentRail)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

