/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"symbol", "buy_price", "sell_price", "buy_price_last_updated_at", "sell_price_last_updated_at"})
@JsonTypeName(value="SymbolPrice")
public class SymbolPriceBankModel {
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_BUY_PRICE = "buy_price";
    private BigInteger buyPrice;
    public static final String JSON_PROPERTY_SELL_PRICE = "sell_price";
    private BigInteger sellPrice;
    public static final String JSON_PROPERTY_BUY_PRICE_LAST_UPDATED_AT = "buy_price_last_updated_at";
    private OffsetDateTime buyPriceLastUpdatedAt;
    public static final String JSON_PROPERTY_SELL_PRICE_LAST_UPDATED_AT = "sell_price_last_updated_at";
    private OffsetDateTime sellPriceLastUpdatedAt;

    public SymbolPriceBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The trade symbol the pricing is related to. Format is asset-counter_asset, e.g., BTC-USD.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public SymbolPriceBankModel buyPrice(BigInteger buyPrice) {
        this.buyPrice = buyPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The purchase price (in base units) for the asset denominated in the counter asset currency.")
    @JsonProperty(value="buy_price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getBuyPrice() {
        return this.buyPrice;
    }

    @JsonProperty(value="buy_price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBuyPrice(BigInteger buyPrice) {
        this.buyPrice = buyPrice;
    }

    public SymbolPriceBankModel sellPrice(BigInteger sellPrice) {
        this.sellPrice = sellPrice;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The sale price (in base units) for the asset denominated in the counter asset currency.")
    @JsonProperty(value="sell_price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getSellPrice() {
        return this.sellPrice;
    }

    @JsonProperty(value="sell_price")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellPrice(BigInteger sellPrice) {
        this.sellPrice = sellPrice;
    }

    public SymbolPriceBankModel buyPriceLastUpdatedAt(OffsetDateTime buyPriceLastUpdatedAt) {
        this.buyPriceLastUpdatedAt = buyPriceLastUpdatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the purchase price was generated at.")
    @JsonProperty(value="buy_price_last_updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getBuyPriceLastUpdatedAt() {
        return this.buyPriceLastUpdatedAt;
    }

    @JsonProperty(value="buy_price_last_updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBuyPriceLastUpdatedAt(OffsetDateTime buyPriceLastUpdatedAt) {
        this.buyPriceLastUpdatedAt = buyPriceLastUpdatedAt;
    }

    public SymbolPriceBankModel sellPriceLastUpdatedAt(OffsetDateTime sellPriceLastUpdatedAt) {
        this.sellPriceLastUpdatedAt = sellPriceLastUpdatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the sale price was generated at.")
    @JsonProperty(value="sell_price_last_updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getSellPriceLastUpdatedAt() {
        return this.sellPriceLastUpdatedAt;
    }

    @JsonProperty(value="sell_price_last_updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSellPriceLastUpdatedAt(OffsetDateTime sellPriceLastUpdatedAt) {
        this.sellPriceLastUpdatedAt = sellPriceLastUpdatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SymbolPriceBankModel symbolPrice = (SymbolPriceBankModel)o;
        return Objects.equals(this.symbol, symbolPrice.symbol) && Objects.equals(this.buyPrice, symbolPrice.buyPrice) && Objects.equals(this.sellPrice, symbolPrice.sellPrice) && Objects.equals(this.buyPriceLastUpdatedAt, symbolPrice.buyPriceLastUpdatedAt) && Objects.equals(this.sellPriceLastUpdatedAt, symbolPrice.sellPriceLastUpdatedAt);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.buyPrice, this.sellPrice, this.buyPriceLastUpdatedAt, this.sellPriceLastUpdatedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SymbolPriceBankModel {\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    buyPrice: ").append(this.toIndentedString(this.buyPrice)).append("\n");
        sb.append("    sellPrice: ").append(this.toIndentedString(this.sellPrice)).append("\n");
        sb.append("    buyPriceLastUpdatedAt: ").append(this.toIndentedString(this.buyPriceLastUpdatedAt)).append("\n");
        sb.append("    sellPriceLastUpdatedAt: ").append(this.toIndentedString(this.sellPriceLastUpdatedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

