/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.IdentityVerificationBankModel;
import app.cybrid.cybrid_api_bank.client.model.IdentityVerificationListBankModel;
import app.cybrid.cybrid_api_bank.client.model.IdentityVerificationWithDetailsBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostIdentityVerificationBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class IdentityVerificationsBankApi {
    private ApiClient apiClient;

    public IdentityVerificationsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public IdentityVerificationsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createIdentityVerificationRequestCreation(PostIdentityVerificationBankModel postIdentityVerificationBankModel) throws WebClientResponseException {
        PostIdentityVerificationBankModel postBody = postIdentityVerificationBankModel;
        if (postIdentityVerificationBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postIdentityVerificationBankModel' when calling createIdentityVerification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<IdentityVerificationBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationBankModel>(){};
        return this.apiClient.invokeAPI("/api/identity_verifications", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<IdentityVerificationBankModel> createIdentityVerification(PostIdentityVerificationBankModel postIdentityVerificationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityVerificationBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationBankModel>(){};
        return this.createIdentityVerificationRequestCreation(postIdentityVerificationBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<IdentityVerificationBankModel>> createIdentityVerificationWithHttpInfo(PostIdentityVerificationBankModel postIdentityVerificationBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityVerificationBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationBankModel>(){};
        return this.createIdentityVerificationRequestCreation(postIdentityVerificationBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getIdentityVerificationRequestCreation(String identityVerificationGuid, Boolean includePii) throws WebClientResponseException {
        Object postBody = null;
        if (identityVerificationGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'identityVerificationGuid' when calling getIdentityVerification", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("identity_verification_guid", identityVerificationGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "include_pii", includePii));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<IdentityVerificationWithDetailsBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationWithDetailsBankModel>(){};
        return this.apiClient.invokeAPI("/api/identity_verifications/{identity_verification_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<IdentityVerificationWithDetailsBankModel> getIdentityVerification(String identityVerificationGuid, Boolean includePii) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityVerificationWithDetailsBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationWithDetailsBankModel>(){};
        return this.getIdentityVerificationRequestCreation(identityVerificationGuid, includePii).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<IdentityVerificationWithDetailsBankModel>> getIdentityVerificationWithHttpInfo(String identityVerificationGuid, Boolean includePii) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityVerificationWithDetailsBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationWithDetailsBankModel>(){};
        return this.getIdentityVerificationRequestCreation(identityVerificationGuid, includePii).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listIdentityVerificationsRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String state) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "state", state));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<IdentityVerificationListBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationListBankModel>(){};
        return this.apiClient.invokeAPI("/api/identity_verifications", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<IdentityVerificationListBankModel> listIdentityVerifications(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String state) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityVerificationListBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationListBankModel>(){};
        return this.listIdentityVerificationsRequestCreation(page, perPage, guid, bankGuid, customerGuid, state).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<IdentityVerificationListBankModel>> listIdentityVerificationsWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String state) throws WebClientResponseException {
        ParameterizedTypeReference<IdentityVerificationListBankModel> localVarReturnType = new ParameterizedTypeReference<IdentityVerificationListBankModel>(){};
        return this.listIdentityVerificationsRequestCreation(page, perPage, guid, bankGuid, customerGuid, state).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

