/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "customer_guid", "invoice_guid", "created_at", "updated_at", "expired_at", "failed_at", "network_address", "expected_payment_asset", "expected_payment_amount", "failure_code", "state"})
@JsonTypeName(value="PaymentInstruction")
public class PaymentInstructionBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_INVOICE_GUID = "invoice_guid";
    private String invoiceGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_EXPIRED_AT = "expired_at";
    private OffsetDateTime expiredAt;
    public static final String JSON_PROPERTY_FAILED_AT = "failed_at";
    private OffsetDateTime failedAt;
    public static final String JSON_PROPERTY_NETWORK_ADDRESS = "network_address";
    private String networkAddress;
    public static final String JSON_PROPERTY_EXPECTED_PAYMENT_ASSET = "expected_payment_asset";
    private String expectedPaymentAsset;
    public static final String JSON_PROPERTY_EXPECTED_PAYMENT_AMOUNT = "expected_payment_amount";
    private BigInteger expectedPaymentAmount;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private String failureCode;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public PaymentInstructionBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the payment instruction.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public PaymentInstructionBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public PaymentInstructionBankModel invoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The invoice identifier.")
    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInvoiceGuid() {
        return this.invoiceGuid;
    }

    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
    }

    public PaymentInstructionBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PaymentInstructionBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PaymentInstructionBankModel expiredAt(OffsetDateTime expiredAt) {
        this.expiredAt = expiredAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the instructions expired at.")
    @JsonProperty(value="expired_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiredAt() {
        return this.expiredAt;
    }

    @JsonProperty(value="expired_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiredAt(OffsetDateTime expiredAt) {
        this.expiredAt = expiredAt;
    }

    public PaymentInstructionBankModel failedAt(OffsetDateTime failedAt) {
        this.failedAt = failedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the instructions failed to be created at.")
    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getFailedAt() {
        return this.failedAt;
    }

    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailedAt(OffsetDateTime failedAt) {
        this.failedAt = failedAt;
    }

    public PaymentInstructionBankModel networkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network address to pay the invoice to.")
    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public PaymentInstructionBankModel expectedPaymentAsset(String expectedPaymentAsset) {
        this.expectedPaymentAsset = expectedPaymentAsset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset the payor must pay the invoice in, e.g., BTC.")
    @JsonProperty(value="expected_payment_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getExpectedPaymentAsset() {
        return this.expectedPaymentAsset;
    }

    @JsonProperty(value="expected_payment_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedPaymentAsset(String expectedPaymentAsset) {
        this.expectedPaymentAsset = expectedPaymentAsset;
    }

    public PaymentInstructionBankModel expectedPaymentAmount(BigInteger expectedPaymentAmount) {
        this.expectedPaymentAmount = expectedPaymentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be paid in base units of expected_payment_asset.")
    @JsonProperty(value="expected_payment_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getExpectedPaymentAmount() {
        return this.expectedPaymentAmount;
    }

    @JsonProperty(value="expected_payment_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpectedPaymentAmount(BigInteger expectedPaymentAmount) {
        this.expectedPaymentAmount = expectedPaymentAmount;
    }

    public PaymentInstructionBankModel failureCode(String failureCode) {
        this.failureCode = failureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason code explaining the failure; ond of invoice_paid, invoice_cancelled, or invalid_amount.")
    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFailureCode() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFailureCode(String failureCode) {
        this.failureCode = failureCode;
    }

    public PaymentInstructionBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the payment instruction; one of storing, created, expired, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstructionBankModel paymentInstruction = (PaymentInstructionBankModel)o;
        return Objects.equals(this.guid, paymentInstruction.guid) && Objects.equals(this.customerGuid, paymentInstruction.customerGuid) && Objects.equals(this.invoiceGuid, paymentInstruction.invoiceGuid) && Objects.equals(this.createdAt, paymentInstruction.createdAt) && Objects.equals(this.updatedAt, paymentInstruction.updatedAt) && Objects.equals(this.expiredAt, paymentInstruction.expiredAt) && Objects.equals(this.failedAt, paymentInstruction.failedAt) && Objects.equals(this.networkAddress, paymentInstruction.networkAddress) && Objects.equals(this.expectedPaymentAsset, paymentInstruction.expectedPaymentAsset) && Objects.equals(this.expectedPaymentAmount, paymentInstruction.expectedPaymentAmount) && Objects.equals(this.failureCode, paymentInstruction.failureCode) && Objects.equals(this.state, paymentInstruction.state);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.customerGuid, this.invoiceGuid, this.createdAt, this.updatedAt, this.expiredAt, this.failedAt, this.networkAddress, this.expectedPaymentAsset, this.expectedPaymentAmount, this.failureCode, this.state);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstructionBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    invoiceGuid: ").append(this.toIndentedString(this.invoiceGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    expiredAt: ").append(this.toIndentedString(this.expiredAt)).append("\n");
        sb.append("    failedAt: ").append(this.toIndentedString(this.failedAt)).append("\n");
        sb.append("    networkAddress: ").append(this.toIndentedString(this.networkAddress)).append("\n");
        sb.append("    expectedPaymentAsset: ").append(this.toIndentedString(this.expectedPaymentAsset)).append("\n");
        sb.append("    expectedPaymentAmount: ").append(this.toIndentedString(this.expectedPaymentAmount)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

