/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.api;

import app.cybrid.cybrid_api_bank.client.ApiClient;
import app.cybrid.cybrid_api_bank.client.model.PaymentInstructionBankModel;
import app.cybrid.cybrid_api_bank.client.model.PaymentInstructionListBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostPaymentInstructionBankModel;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.reactive.function.client.WebClientResponseException;
import reactor.core.publisher.Mono;

public class PaymentInstructionsBankApi {
    private ApiClient apiClient;

    public PaymentInstructionsBankApi() {
        this(new ApiClient());
    }

    @Autowired
    public PaymentInstructionsBankApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    private WebClient.ResponseSpec createPaymentInstructionRequestCreation(PostPaymentInstructionBankModel postPaymentInstructionBankModel) throws WebClientResponseException {
        PostPaymentInstructionBankModel postBody = postPaymentInstructionBankModel;
        if (postPaymentInstructionBankModel == null) {
            throw new WebClientResponseException("Missing the required parameter 'postPaymentInstructionBankModel' when calling createPaymentInstruction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{"application/json"};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<PaymentInstructionBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionBankModel>(){};
        return this.apiClient.invokeAPI("/api/payment_instructions", HttpMethod.POST, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PaymentInstructionBankModel> createPaymentInstruction(PostPaymentInstructionBankModel postPaymentInstructionBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<PaymentInstructionBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionBankModel>(){};
        return this.createPaymentInstructionRequestCreation(postPaymentInstructionBankModel).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PaymentInstructionBankModel>> createPaymentInstructionWithHttpInfo(PostPaymentInstructionBankModel postPaymentInstructionBankModel) throws WebClientResponseException {
        ParameterizedTypeReference<PaymentInstructionBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionBankModel>(){};
        return this.createPaymentInstructionRequestCreation(postPaymentInstructionBankModel).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec getPaymentInstructionRequestCreation(String paymentInstructionGuid) throws WebClientResponseException {
        Object postBody = null;
        if (paymentInstructionGuid == null) {
            throw new WebClientResponseException("Missing the required parameter 'paymentInstructionGuid' when calling getPaymentInstruction", HttpStatus.BAD_REQUEST.value(), HttpStatus.BAD_REQUEST.getReasonPhrase(), null, null, null);
        }
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        pathParams.put("payment_instruction_guid", paymentInstructionGuid);
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<PaymentInstructionBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionBankModel>(){};
        return this.apiClient.invokeAPI("/api/payment_instructions/{payment_instruction_guid}", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PaymentInstructionBankModel> getPaymentInstruction(String paymentInstructionGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PaymentInstructionBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionBankModel>(){};
        return this.getPaymentInstructionRequestCreation(paymentInstructionGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PaymentInstructionBankModel>> getPaymentInstructionWithHttpInfo(String paymentInstructionGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PaymentInstructionBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionBankModel>(){};
        return this.getPaymentInstructionRequestCreation(paymentInstructionGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }

    private WebClient.ResponseSpec listPaymentInstructionsRequestCreation(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String invoiceGuid) throws WebClientResponseException {
        Object postBody = null;
        HashMap<String, Object> pathParams = new HashMap<String, Object>();
        LinkedMultiValueMap queryParams = new LinkedMultiValueMap();
        HttpHeaders headerParams = new HttpHeaders();
        LinkedMultiValueMap cookieParams = new LinkedMultiValueMap();
        LinkedMultiValueMap formParams = new LinkedMultiValueMap();
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "page", page));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "per_page", perPage));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "guid", guid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "bank_guid", bankGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "customer_guid", customerGuid));
        queryParams.putAll(this.apiClient.parameterToMultiValueMap(null, "invoice_guid", invoiceGuid));
        String[] localVarAccepts = new String[]{"application/json"};
        List<MediaType> localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        String[] localVarContentTypes = new String[]{};
        MediaType localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        String[] localVarAuthNames = new String[]{"BearerAuth", "oauth2"};
        ParameterizedTypeReference<PaymentInstructionListBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionListBankModel>(){};
        return this.apiClient.invokeAPI("/api/payment_instructions", HttpMethod.GET, pathParams, (MultiValueMap<String, String>)queryParams, postBody, headerParams, (MultiValueMap<String, String>)cookieParams, (MultiValueMap<String, Object>)formParams, localVarAccept, localVarContentType, localVarAuthNames, localVarReturnType);
    }

    public Mono<PaymentInstructionListBankModel> listPaymentInstructions(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String invoiceGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PaymentInstructionListBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionListBankModel>(){};
        return this.listPaymentInstructionsRequestCreation(page, perPage, guid, bankGuid, customerGuid, invoiceGuid).bodyToMono((ParameterizedTypeReference)localVarReturnType);
    }

    public Mono<ResponseEntity<PaymentInstructionListBankModel>> listPaymentInstructionsWithHttpInfo(BigInteger page, BigInteger perPage, String guid, String bankGuid, String customerGuid, String invoiceGuid) throws WebClientResponseException {
        ParameterizedTypeReference<PaymentInstructionListBankModel> localVarReturnType = new ParameterizedTypeReference<PaymentInstructionListBankModel>(){};
        return this.listPaymentInstructionsRequestCreation(page, perPage, guid, bankGuid, customerGuid, invoiceGuid).toEntity((ParameterizedTypeReference)localVarReturnType);
    }
}

