/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "product_type", "bank_guid", "customer_guid", "symbol", "side", "receive_amount", "deliver_amount", "fee", "created_at", "updated_at", "issued_at", "expires_at", "asset", "network_fee", "network_fee_asset", "network_address"})
@JsonTypeName(value="Quote")
public class QuoteBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_PRODUCT_TYPE = "product_type";
    private String productType;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_SYMBOL = "symbol";
    private String symbol;
    public static final String JSON_PROPERTY_SIDE = "side";
    private String side;
    public static final String JSON_PROPERTY_RECEIVE_AMOUNT = "receive_amount";
    private BigInteger receiveAmount;
    public static final String JSON_PROPERTY_DELIVER_AMOUNT = "deliver_amount";
    private BigInteger deliverAmount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private BigInteger fee;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_ISSUED_AT = "issued_at";
    private OffsetDateTime issuedAt;
    public static final String JSON_PROPERTY_EXPIRES_AT = "expires_at";
    private OffsetDateTime expiresAt;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_NETWORK_FEE = "network_fee";
    private BigInteger networkFee;
    public static final String JSON_PROPERTY_NETWORK_FEE_ASSET = "network_fee_asset";
    private String networkFeeAsset;
    public static final String JSON_PROPERTY_NETWORK_ADDRESS = "network_address";
    private String networkAddress;

    public QuoteBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the quote.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public QuoteBankModel productType(String productType) {
        this.productType = productType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of product the quote is for; one of trading, trading_exit, funding, book_transfer, crypto_transfer, inter_account, or lightning_transfer.")
    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getProductType() {
        return this.productType;
    }

    @JsonProperty(value="product_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setProductType(String productType) {
        this.productType = productType;
    }

    public QuoteBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the bank.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public QuoteBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier for the customer.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public QuoteBankModel symbol(String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Symbol the quote was requested for. Format is \"asset-counter_asset\" in uppercase. Populated for trade quotes.")
    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSymbol() {
        return this.symbol;
    }

    @JsonProperty(value="symbol")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public QuoteBankModel side(String side) {
        this.side = side;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction of the quote; one of buy, sell, deposit, or withdrawal.")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSide(String side) {
        this.side = side;
    }

    public QuoteBankModel receiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be received in base units of the currency: currency is \"asset\" for buy and \"counter_asset\" for sell for trade quotes.")
    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getReceiveAmount() {
        return this.receiveAmount;
    }

    @JsonProperty(value="receive_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setReceiveAmount(BigInteger receiveAmount) {
        this.receiveAmount = receiveAmount;
    }

    public QuoteBankModel deliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be delivered in base units of the currency: currency is \"counter_asset\" for buy and \"asset\" for sell for trade quotes.")
    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getDeliverAmount() {
        return this.deliverAmount;
    }

    @JsonProperty(value="deliver_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeliverAmount(BigInteger deliverAmount) {
        this.deliverAmount = deliverAmount;
    }

    public QuoteBankModel fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee associated with the trade. Denominated in \"counter_asset\" base units for trade quotes.")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public QuoteBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public QuoteBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public QuoteBankModel issuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the quote was created at.")
    @JsonProperty(value="issued_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getIssuedAt() {
        return this.issuedAt;
    }

    @JsonProperty(value="issued_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setIssuedAt(OffsetDateTime issuedAt) {
        this.issuedAt = issuedAt;
    }

    public QuoteBankModel expiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the quote is expiring at. Populated for trading quotes.")
    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getExpiresAt() {
        return this.expiresAt;
    }

    @JsonProperty(value="expires_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setExpiresAt(OffsetDateTime expiresAt) {
        this.expiresAt = expiresAt;
    }

    public QuoteBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code the quote was requested for. Populated for book transfer and funding quotes.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public QuoteBankModel networkFee(BigInteger networkFee) {
        this.networkFee = networkFee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network fee in base units of network_fee_asset. Only present on `crypto_transfer` quotes.")
    @JsonProperty(value="network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getNetworkFee() {
        return this.networkFee;
    }

    @JsonProperty(value="network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFee(BigInteger networkFee) {
        this.networkFee = networkFee;
    }

    public QuoteBankModel networkFeeAsset(String networkFeeAsset) {
        this.networkFeeAsset = networkFeeAsset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code of the network fee.")
    @JsonProperty(value="network_fee_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkFeeAsset() {
        return this.networkFeeAsset;
    }

    @JsonProperty(value="network_fee_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkFeeAsset(String networkFeeAsset) {
        this.networkFeeAsset = networkFeeAsset;
    }

    public QuoteBankModel networkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network address to pay the invoice to. Populated for lightning_transfer quotes.")
    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getNetworkAddress() {
        return this.networkAddress;
    }

    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = networkAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuoteBankModel quote = (QuoteBankModel)o;
        return Objects.equals(this.guid, quote.guid) && Objects.equals(this.productType, quote.productType) && Objects.equals(this.bankGuid, quote.bankGuid) && Objects.equals(this.customerGuid, quote.customerGuid) && Objects.equals(this.symbol, quote.symbol) && Objects.equals(this.side, quote.side) && Objects.equals(this.receiveAmount, quote.receiveAmount) && Objects.equals(this.deliverAmount, quote.deliverAmount) && Objects.equals(this.fee, quote.fee) && Objects.equals(this.createdAt, quote.createdAt) && Objects.equals(this.updatedAt, quote.updatedAt) && Objects.equals(this.issuedAt, quote.issuedAt) && Objects.equals(this.expiresAt, quote.expiresAt) && Objects.equals(this.asset, quote.asset) && Objects.equals(this.networkFee, quote.networkFee) && Objects.equals(this.networkFeeAsset, quote.networkFeeAsset) && Objects.equals(this.networkAddress, quote.networkAddress);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.productType, this.bankGuid, this.customerGuid, this.symbol, this.side, this.receiveAmount, this.deliverAmount, this.fee, this.createdAt, this.updatedAt, this.issuedAt, this.expiresAt, this.asset, this.networkFee, this.networkFeeAsset, this.networkAddress);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class QuoteBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    symbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("    side: ").append(this.toIndentedString(this.side)).append("\n");
        sb.append("    receiveAmount: ").append(this.toIndentedString(this.receiveAmount)).append("\n");
        sb.append("    deliverAmount: ").append(this.toIndentedString(this.deliverAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    issuedAt: ").append(this.toIndentedString(this.issuedAt)).append("\n");
        sb.append("    expiresAt: ").append(this.toIndentedString(this.expiresAt)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    networkFee: ").append(this.toIndentedString(this.networkFee)).append("\n");
        sb.append("    networkFeeAsset: ").append(this.toIndentedString(this.networkFeeAsset)).append("\n");
        sb.append("    networkAddress: ").append(this.toIndentedString(this.networkAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

