/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"guid", "bank_guid", "customer_guid", "account_guid", "created_at", "updated_at", "asset", "state", "address", "format", "tag", "labels"})
@JsonTypeName(value="DepositAddress")
public class DepositAddressBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private String bankGuid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private String customerGuid;
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private String accountGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private String address;
    public static final String JSON_PROPERTY_FORMAT = "format";
    private String format;
    public static final String JSON_PROPERTY_TAG = "tag";
    private String tag;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private List<String> labels = null;

    public DepositAddressBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the identity verification.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public DepositAddressBankModel bankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The address' bank identifier.")
    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getBankGuid() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setBankGuid(String bankGuid) {
        this.bankGuid = bankGuid;
    }

    public DepositAddressBankModel customerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The address' customer identifier.")
    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCustomerGuid() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = customerGuid;
    }

    public DepositAddressBankModel accountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The address' account identifier.")
    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAccountGuid() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAccountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
    }

    public DepositAddressBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DepositAddressBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public DepositAddressBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset the transfer is related to, e.g., USD.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public DepositAddressBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the address; one of storing or created.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public DepositAddressBankModel address(String address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The blockchain address.")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAddress(String address) {
        this.address = address;
    }

    public DepositAddressBankModel format(String format) {
        this.format = format;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The blockchain address format; one of standard or legacy.")
    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFormat(String format) {
        this.format = format;
    }

    public DepositAddressBankModel tag(String tag) {
        this.tag = tag;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The blockchain address tag.")
    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTag() {
        return this.tag;
    }

    @JsonProperty(value="tag")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTag(String tag) {
        this.tag = tag;
    }

    public DepositAddressBankModel labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    public DepositAddressBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(labelsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the address.")
    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public List<String> getLabels() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositAddressBankModel depositAddress = (DepositAddressBankModel)o;
        return Objects.equals(this.guid, depositAddress.guid) && Objects.equals(this.bankGuid, depositAddress.bankGuid) && Objects.equals(this.customerGuid, depositAddress.customerGuid) && Objects.equals(this.accountGuid, depositAddress.accountGuid) && Objects.equals(this.createdAt, depositAddress.createdAt) && Objects.equals(this.updatedAt, depositAddress.updatedAt) && Objects.equals(this.asset, depositAddress.asset) && Objects.equals(this.state, depositAddress.state) && Objects.equals(this.address, depositAddress.address) && Objects.equals(this.format, depositAddress.format) && Objects.equals(this.tag, depositAddress.tag) && Objects.equals(this.labels, depositAddress.labels);
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.bankGuid, this.customerGuid, this.accountGuid, this.createdAt, this.updatedAt, this.asset, this.state, this.address, this.format, this.tag, this.labels);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositAddressBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    format: ").append(this.toIndentedString(this.format)).append("\n");
        sb.append("    tag: ").append(this.toIndentedString(this.tag)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

