/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The customer's address. Optional when type is individual.")
@JsonPropertyOrder(value={"street", "street2", "city", "subdivision", "postal_code", "country_code"})
@JsonTypeName(value="PostCustomer_address")
public class PostCustomerAddressBankModel {
    public static final String JSON_PROPERTY_STREET = "street";
    private String street;
    public static final String JSON_PROPERTY_STREET2 = "street2";
    private String street2;
    public static final String JSON_PROPERTY_CITY = "city";
    private String city;
    public static final String JSON_PROPERTY_SUBDIVISION = "subdivision";
    private String subdivision;
    public static final String JSON_PROPERTY_POSTAL_CODE = "postal_code";
    private String postalCode;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "country_code";
    private String countryCode;

    public PostCustomerAddressBankModel street(String street) {
        this.street = street;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The first line of the address. Required when type is individual.")
    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreet() {
        return this.street;
    }

    @JsonProperty(value="street")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStreet(String street) {
        this.street = street;
    }

    public PostCustomerAddressBankModel street2(String street2) {
        this.street2 = street2;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional second line of the address. Optional when type is individual.")
    @JsonProperty(value="street2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getStreet2() {
        return this.street2;
    }

    @JsonProperty(value="street2")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public PostCustomerAddressBankModel city(String city) {
        this.city = city;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The city of the address. Required when type is individual.")
    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCity() {
        return this.city;
    }

    @JsonProperty(value="city")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCity(String city) {
        this.city = city;
    }

    public PostCustomerAddressBankModel subdivision(String subdivision) {
        this.subdivision = subdivision;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166-2 subdivision code of the address. Applicable only for countries that use subnational states, provinces, lands, oblasts or regions. Optional when type is individual.")
    @JsonProperty(value="subdivision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSubdivision() {
        return this.subdivision;
    }

    @JsonProperty(value="subdivision")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSubdivision(String subdivision) {
        this.subdivision = subdivision;
    }

    public PostCustomerAddressBankModel postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The postal, zip or post code of the address. Applicable only for countries that use postal, zip or post codes. Optional when type is individual.")
    @JsonProperty(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getPostalCode() {
        return this.postalCode;
    }

    @JsonProperty(value="postal_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public PostCustomerAddressBankModel countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO 3166 country 2-Alpha country code of the address. Required when type is individual.")
    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostCustomerAddressBankModel postCustomerAddress = (PostCustomerAddressBankModel)o;
        return Objects.equals(this.street, postCustomerAddress.street) && Objects.equals(this.street2, postCustomerAddress.street2) && Objects.equals(this.city, postCustomerAddress.city) && Objects.equals(this.subdivision, postCustomerAddress.subdivision) && Objects.equals(this.postalCode, postCustomerAddress.postalCode) && Objects.equals(this.countryCode, postCustomerAddress.countryCode);
    }

    public int hashCode() {
        return Objects.hash(this.street, this.street2, this.city, this.subdivision, this.postalCode, this.countryCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostCustomerAddressBankModel {\n");
        sb.append("    street: ").append(this.toIndentedString(this.street)).append("\n");
        sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    subdivision: ").append(this.toIndentedString(this.subdivision)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

