/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Identification number details.")
@JsonPropertyOrder(value={"type", "issuing_country_code", "identification_number"})
@JsonTypeName(value="PostIdentificationNumber")
public class PostIdentificationNumberBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_ISSUING_COUNTRY_CODE = "issuing_country_code";
    private String issuingCountryCode;
    public static final String JSON_PROPERTY_IDENTIFICATION_NUMBER = "identification_number";
    private String identificationNumber;

    public PostIdentificationNumberBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The source of the identification number.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostIdentificationNumberBankModel issuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The ISO 3166 country 2-Alpha country code of the identification number issuer.")
    @JsonProperty(value="issuing_country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIssuingCountryCode() {
        return this.issuingCountryCode;
    }

    @JsonProperty(value="issuing_country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIssuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
    }

    public PostIdentificationNumberBankModel identificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The identification number.")
    @JsonProperty(value="identification_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getIdentificationNumber() {
        return this.identificationNumber;
    }

    @JsonProperty(value="identification_number")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setIdentificationNumber(String identificationNumber) {
        this.identificationNumber = identificationNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostIdentificationNumberBankModel postIdentificationNumber = (PostIdentificationNumberBankModel)o;
        return Objects.equals((Object)this.type, (Object)postIdentificationNumber.type) && Objects.equals(this.issuingCountryCode, postIdentificationNumber.issuingCountryCode) && Objects.equals(this.identificationNumber, postIdentificationNumber.identificationNumber);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.issuingCountryCode, this.identificationNumber});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostIdentificationNumberBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    issuingCountryCode: ").append(this.toIndentedString(this.issuingCountryCode)).append("\n");
        sb.append("    identificationNumber: ").append(this.toIndentedString(this.identificationNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        DRIVERS_LICENSE("drivers_license"),
        PASSPORT("passport"),
        PASSPORT_CARD("passport_card"),
        RESIDENCE_CARD("residence_card"),
        SOCIAL_SECURITY_NUMBER("social_security_number"),
        TAX_IDENTIFICATION_NUMBER("tax_identification_number"),
        IDENTIFICATION_CARD("identification_card"),
        EMPLOYER_IDENTIFICATION_NUMBER("employer_identification_number"),
        BUSINESS_REGISTRATION_NUMBER("business_registration_number");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

