/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for payment instruction creation.")
@JsonPropertyOrder(value={"invoice_guid", "expected_behaviour"})
@JsonTypeName(value="PostPaymentInstruction")
public class PostPaymentInstructionBankModel {
    public static final String JSON_PROPERTY_INVOICE_GUID = "invoice_guid";
    private String invoiceGuid;
    public static final String JSON_PROPERTY_EXPECTED_BEHAVIOUR = "expected_behaviour";
    private JsonNullable<ExpectedBehaviourEnum> expectedBehaviour = JsonNullable.undefined();

    public PostPaymentInstructionBankModel invoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The invoice guid.")
    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getInvoiceGuid() {
        return this.invoiceGuid;
    }

    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setInvoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
    }

    public PostPaymentInstructionBankModel expectedBehaviour(ExpectedBehaviourEnum expectedBehaviour) {
        this.expectedBehaviour = JsonNullable.of((Object)((Object)expectedBehaviour));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected behaviour to simulate.")
    @JsonIgnore
    public ExpectedBehaviourEnum getExpectedBehaviour() {
        return (ExpectedBehaviourEnum)((Object)this.expectedBehaviour.orElse(null));
    }

    @JsonProperty(value="expected_behaviour")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ExpectedBehaviourEnum> getExpectedBehaviour_JsonNullable() {
        return this.expectedBehaviour;
    }

    @JsonProperty(value="expected_behaviour")
    public void setExpectedBehaviour_JsonNullable(JsonNullable<ExpectedBehaviourEnum> expectedBehaviour) {
        this.expectedBehaviour = expectedBehaviour;
    }

    public void setExpectedBehaviour(ExpectedBehaviourEnum expectedBehaviour) {
        this.expectedBehaviour = JsonNullable.of((Object)((Object)expectedBehaviour));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostPaymentInstructionBankModel postPaymentInstruction = (PostPaymentInstructionBankModel)o;
        return Objects.equals(this.invoiceGuid, postPaymentInstruction.invoiceGuid) && PostPaymentInstructionBankModel.equalsNullable(this.expectedBehaviour, postPaymentInstruction.expectedBehaviour);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.invoiceGuid, PostPaymentInstructionBankModel.hashCodeNullable(this.expectedBehaviour));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostPaymentInstructionBankModel {\n");
        sb.append("    invoiceGuid: ").append(this.toIndentedString(this.invoiceGuid)).append("\n");
        sb.append("    expectedBehaviour: ").append(this.toIndentedString(this.expectedBehaviour)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedBehaviourEnum {
        INVOICE_PAID_IMMEDIATELY("invoice_paid_immediately");

        private String value;

        private ExpectedBehaviourEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedBehaviourEnum fromValue(String value) {
            for (ExpectedBehaviourEnum b : ExpectedBehaviourEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

