/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nonnull;

@ApiModel(description="Supported payout symbols details.")
@JsonPropertyOrder(value={"primary_asset", "counter_asset", "country_code", "participants_type", "route"})
@JsonTypeName(value="PostSupportedPayoutSymbols")
public class PostSupportedPayoutSymbolsBankModel {
    public static final String JSON_PROPERTY_PRIMARY_ASSET = "primary_asset";
    private String primaryAsset;
    public static final String JSON_PROPERTY_COUNTER_ASSET = "counter_asset";
    private String counterAsset;
    public static final String JSON_PROPERTY_COUNTRY_CODE = "country_code";
    private String countryCode;
    public static final String JSON_PROPERTY_PARTICIPANTS_TYPE = "participants_type";
    private ParticipantsTypeEnum participantsType;
    public static final String JSON_PROPERTY_ROUTE = "route";
    private RouteEnum route;

    public PostSupportedPayoutSymbolsBankModel primaryAsset(String primaryAsset) {
        this.primaryAsset = primaryAsset;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The primary asset of the payout symbol, e.g., MXN.")
    @JsonProperty(value="primary_asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getPrimaryAsset() {
        return this.primaryAsset;
    }

    @JsonProperty(value="primary_asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPrimaryAsset(String primaryAsset) {
        this.primaryAsset = primaryAsset;
    }

    public PostSupportedPayoutSymbolsBankModel counterAsset(String counterAsset) {
        this.counterAsset = counterAsset;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The counter asset of the payout symbol, e.g., USD.")
    @JsonProperty(value="counter_asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCounterAsset() {
        return this.counterAsset;
    }

    @JsonProperty(value="counter_asset")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCounterAsset(String counterAsset) {
        this.counterAsset = counterAsset;
    }

    public PostSupportedPayoutSymbolsBankModel countryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The ISO 3166 country 2-Alpha country code is permitted in, e.g., MX.")
    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getCountryCode() {
        return this.countryCode;
    }

    @JsonProperty(value="country_code")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public PostSupportedPayoutSymbolsBankModel participantsType(ParticipantsTypeEnum participantsType) {
        this.participantsType = participantsType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The participants the symbol is permitted for.")
    @JsonProperty(value="participants_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ParticipantsTypeEnum getParticipantsType() {
        return this.participantsType;
    }

    @JsonProperty(value="participants_type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setParticipantsType(ParticipantsTypeEnum participantsType) {
        this.participantsType = participantsType;
    }

    public PostSupportedPayoutSymbolsBankModel route(RouteEnum route) {
        this.route = route;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The route the symbol is permitted for.")
    @JsonProperty(value="route")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public RouteEnum getRoute() {
        return this.route;
    }

    @JsonProperty(value="route")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRoute(RouteEnum route) {
        this.route = route;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostSupportedPayoutSymbolsBankModel postSupportedPayoutSymbols = (PostSupportedPayoutSymbolsBankModel)o;
        return Objects.equals(this.primaryAsset, postSupportedPayoutSymbols.primaryAsset) && Objects.equals(this.counterAsset, postSupportedPayoutSymbols.counterAsset) && Objects.equals(this.countryCode, postSupportedPayoutSymbols.countryCode) && Objects.equals((Object)this.participantsType, (Object)postSupportedPayoutSymbols.participantsType) && Objects.equals((Object)this.route, (Object)postSupportedPayoutSymbols.route);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.primaryAsset, this.counterAsset, this.countryCode, this.participantsType, this.route});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostSupportedPayoutSymbolsBankModel {\n");
        sb.append("    primaryAsset: ").append(this.toIndentedString(this.primaryAsset)).append("\n");
        sb.append("    counterAsset: ").append(this.toIndentedString(this.counterAsset)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString(this.countryCode)).append("\n");
        sb.append("    participantsType: ").append(this.toIndentedString((Object)this.participantsType)).append("\n");
        sb.append("    route: ").append(this.toIndentedString((Object)this.route)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum RouteEnum {
        BANK_ACCOUNT("bank_account"),
        MOBILE_WALLET("mobile_wallet");

        private String value;

        private RouteEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static RouteEnum fromValue(String value) {
            for (RouteEnum b : RouteEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum ParticipantsTypeEnum {
        C2C("C2C"),
        C2B("C2B"),
        B2C("B2C"),
        B2B("B2B");

        private String value;

        private ParticipantsTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ParticipantsTypeEnum fromValue(String value) {
            for (ParticipantsTypeEnum b : ParticipantsTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

