/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostCounterpartyAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostCounterpartyAliasesInnerBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostCounterpartyNameBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for counterparty creation.")
@JsonPropertyOrder(value={"type", "customer_guid", "address", "name", "aliases", "date_of_birth", "labels"})
@JsonTypeName(value="PostCounterparty")
public class PostCounterpartyBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ADDRESS = "address";
    private PostCounterpartyAddressBankModel address;
    public static final String JSON_PROPERTY_NAME = "name";
    private JsonNullable<PostCounterpartyNameBankModel> name = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ALIASES = "aliases";
    private JsonNullable<List<PostCounterpartyAliasesInnerBankModel>> aliases = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DATE_OF_BIRTH = "date_of_birth";
    private JsonNullable<LocalDate> dateOfBirth = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostCounterpartyBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The counterparty's type.")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostCounterpartyBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The owning customer's identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostCounterpartyBankModel address(PostCounterpartyAddressBankModel address) {
        this.address = address;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public PostCounterpartyAddressBankModel getAddress() {
        return this.address;
    }

    @JsonProperty(value="address")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAddress(PostCounterpartyAddressBankModel address) {
        this.address = address;
    }

    public PostCounterpartyBankModel name(PostCounterpartyNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostCounterpartyNameBankModel getName() {
        return (PostCounterpartyNameBankModel)this.name.orElse(null);
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostCounterpartyNameBankModel> getName_JsonNullable() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName_JsonNullable(JsonNullable<PostCounterpartyNameBankModel> name) {
        this.name = name;
    }

    public void setName(PostCounterpartyNameBankModel name) {
        this.name = JsonNullable.of((Object)name);
    }

    public PostCounterpartyBankModel aliases(List<PostCounterpartyAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
        return this;
    }

    public PostCounterpartyBankModel addAliasesItem(PostCounterpartyAliasesInnerBankModel aliasesItem) {
        if (this.aliases == null || !this.aliases.isPresent()) {
            this.aliases = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.aliases.get()).add(aliasesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The aliases of the counterparty. Optional when type is business.")
    @JsonIgnore
    public List<PostCounterpartyAliasesInnerBankModel> getAliases() {
        return (List)this.aliases.orElse(null);
    }

    @JsonProperty(value="aliases")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<PostCounterpartyAliasesInnerBankModel>> getAliases_JsonNullable() {
        return this.aliases;
    }

    @JsonProperty(value="aliases")
    public void setAliases_JsonNullable(JsonNullable<List<PostCounterpartyAliasesInnerBankModel>> aliases) {
        this.aliases = aliases;
    }

    public void setAliases(List<PostCounterpartyAliasesInnerBankModel> aliases) {
        this.aliases = JsonNullable.of(aliases);
    }

    public PostCounterpartyBankModel dateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's date of birth. Optional when type is individual.")
    @JsonIgnore
    public LocalDate getDateOfBirth() {
        return (LocalDate)this.dateOfBirth.orElse(null);
    }

    @JsonProperty(value="date_of_birth")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<LocalDate> getDateOfBirth_JsonNullable() {
        return this.dateOfBirth;
    }

    @JsonProperty(value="date_of_birth")
    public void setDateOfBirth_JsonNullable(JsonNullable<LocalDate> dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = JsonNullable.of((Object)dateOfBirth);
    }

    public PostCounterpartyBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostCounterpartyBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the counterparty.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostCounterpartyBankModel postCounterparty = (PostCounterpartyBankModel)o;
        return Objects.equals((Object)this.type, (Object)postCounterparty.type) && PostCounterpartyBankModel.equalsNullable(this.customerGuid, postCounterparty.customerGuid) && Objects.equals(this.address, postCounterparty.address) && PostCounterpartyBankModel.equalsNullable(this.name, postCounterparty.name) && PostCounterpartyBankModel.equalsNullable(this.aliases, postCounterparty.aliases) && PostCounterpartyBankModel.equalsNullable(this.dateOfBirth, postCounterparty.dateOfBirth) && PostCounterpartyBankModel.equalsNullable(this.labels, postCounterparty.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, PostCounterpartyBankModel.hashCodeNullable(this.customerGuid), this.address, PostCounterpartyBankModel.hashCodeNullable(this.name), PostCounterpartyBankModel.hashCodeNullable(this.aliases), PostCounterpartyBankModel.hashCodeNullable(this.dateOfBirth), PostCounterpartyBankModel.hashCodeNullable(this.labels)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostCounterpartyBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    aliases: ").append(this.toIndentedString(this.aliases)).append("\n");
        sb.append("    dateOfBirth: ").append(this.toIndentedString(this.dateOfBirth)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        BUSINESS("business"),
        INDIVIDUAL("individual");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

