/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for deposit address creation.")
@JsonPropertyOrder(value={"account_guid", "labels"})
@JsonTypeName(value="PostDepositAddress")
public class PostDepositAddressBankModel {
    public static final String JSON_PROPERTY_ACCOUNT_GUID = "account_guid";
    private String accountGuid;
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostDepositAddressBankModel accountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The trading account guid.")
    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAccountGuid() {
        return this.accountGuid;
    }

    @JsonProperty(value="account_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountGuid(String accountGuid) {
        this.accountGuid = accountGuid;
    }

    public PostDepositAddressBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostDepositAddressBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the address.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostDepositAddressBankModel postDepositAddress = (PostDepositAddressBankModel)o;
        return Objects.equals(this.accountGuid, postDepositAddress.accountGuid) && PostDepositAddressBankModel.equalsNullable(this.labels, postDepositAddress.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.accountGuid, PostDepositAddressBankModel.hashCodeNullable(this.labels));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostDepositAddressBankModel {\n");
        sb.append("    accountGuid: ").append(this.toIndentedString(this.accountGuid)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

