/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for fee creation.")
@JsonPropertyOrder(value={"type", "spread_fee", "fixed_fee"})
@JsonTypeName(value="PostFee")
public class PostFeeBankModel {
    public static final String JSON_PROPERTY_TYPE = "type";
    private TypeEnum type;
    public static final String JSON_PROPERTY_SPREAD_FEE = "spread_fee";
    private JsonNullable<BigInteger> spreadFee = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FIXED_FEE = "fixed_fee";
    private JsonNullable<BigInteger> fixedFee = JsonNullable.undefined();

    public PostFeeBankModel type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fee's type")
    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public PostFeeBankModel spreadFee(BigInteger spreadFee) {
        this.spreadFee = JsonNullable.of((Object)spreadFee);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The percentage amount, in basis points, to apply when charging a fee. Required when type is spread.")
    @JsonIgnore
    public BigInteger getSpreadFee() {
        return (BigInteger)this.spreadFee.orElse(null);
    }

    @JsonProperty(value="spread_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getSpreadFee_JsonNullable() {
        return this.spreadFee;
    }

    @JsonProperty(value="spread_fee")
    public void setSpreadFee_JsonNullable(JsonNullable<BigInteger> spreadFee) {
        this.spreadFee = spreadFee;
    }

    public void setSpreadFee(BigInteger spreadFee) {
        this.spreadFee = JsonNullable.of((Object)spreadFee);
    }

    public PostFeeBankModel fixedFee(BigInteger fixedFee) {
        this.fixedFee = JsonNullable.of((Object)fixedFee);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fixed amount to apply when charging a fee; for trades, the fiat asset is used. Required when type is fixed.")
    @JsonIgnore
    public BigInteger getFixedFee() {
        return (BigInteger)this.fixedFee.orElse(null);
    }

    @JsonProperty(value="fixed_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getFixedFee_JsonNullable() {
        return this.fixedFee;
    }

    @JsonProperty(value="fixed_fee")
    public void setFixedFee_JsonNullable(JsonNullable<BigInteger> fixedFee) {
        this.fixedFee = fixedFee;
    }

    public void setFixedFee(BigInteger fixedFee) {
        this.fixedFee = JsonNullable.of((Object)fixedFee);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostFeeBankModel postFee = (PostFeeBankModel)o;
        return Objects.equals((Object)this.type, (Object)postFee.type) && PostFeeBankModel.equalsNullable(this.spreadFee, postFee.spreadFee) && PostFeeBankModel.equalsNullable(this.fixedFee, postFee.fixedFee);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, PostFeeBankModel.hashCodeNullable(this.spreadFee), PostFeeBankModel.hashCodeNullable(this.fixedFee)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostFeeBankModel {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    spreadFee: ").append(this.toIndentedString(this.spreadFee)).append("\n");
        sb.append("    fixedFee: ").append(this.toIndentedString(this.fixedFee)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        SPREAD("spread"),
        FIXED("fixed");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

