/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.TransferDestinationAccountBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferEntryBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferParticipantBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferSourceAccountBankModel;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "transfer_type", "bank_guid", "customer_guid", "quote_guid", "external_bank_account_guid", "asset", "side", "state", "failure_code", "return_code", "amount", "estimated_amount", "fee", "estimated_network_fee", "network_fee", "network_fee_asset", "network_fee_liability_amount", "network_fee_liability_amount_asset", "txn_hash", "reference_transfer_guid", "source_account", "source_participants", "destination_account", "destination_participants", "created_at", "updated_at", "transfer_details", "payment_rail", "labels", "entries"})
@JsonTypeName(value="Transfer")
public class TransferBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_TRANSFER_TYPE = "transfer_type";
    private String transferType;
    public static final String JSON_PROPERTY_BANK_GUID = "bank_guid";
    private JsonNullable<String> bankGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_EXTERNAL_BANK_ACCOUNT_GUID = "external_bank_account_guid";
    private JsonNullable<String> externalBankAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ASSET = "asset";
    private String asset;
    public static final String JSON_PROPERTY_SIDE = "side";
    private String side;
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private JsonNullable<String> failureCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_RETURN_CODE = "return_code";
    private JsonNullable<String> returnCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private JsonNullable<BigInteger> amount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ESTIMATED_AMOUNT = "estimated_amount";
    private BigInteger estimatedAmount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private BigInteger fee;
    public static final String JSON_PROPERTY_ESTIMATED_NETWORK_FEE = "estimated_network_fee";
    private JsonNullable<BigInteger> estimatedNetworkFee = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_FEE = "network_fee";
    private JsonNullable<BigInteger> networkFee = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_FEE_ASSET = "network_fee_asset";
    private JsonNullable<String> networkFeeAsset = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT = "network_fee_liability_amount";
    private JsonNullable<BigInteger> networkFeeLiabilityAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_FEE_LIABILITY_AMOUNT_ASSET = "network_fee_liability_amount_asset";
    private JsonNullable<String> networkFeeLiabilityAmountAsset = JsonNullable.undefined();
    public static final String JSON_PROPERTY_TXN_HASH = "txn_hash";
    private JsonNullable<String> txnHash = JsonNullable.undefined();
    public static final String JSON_PROPERTY_REFERENCE_TRANSFER_GUID = "reference_transfer_guid";
    private JsonNullable<String> referenceTransferGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT = "source_account";
    private JsonNullable<TransferSourceAccountBankModel> sourceAccount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_SOURCE_PARTICIPANTS = "source_participants";
    private JsonNullable<List<TransferParticipantBankModel>> sourceParticipants = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT = "destination_account";
    private JsonNullable<TransferDestinationAccountBankModel> destinationAccount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_DESTINATION_PARTICIPANTS = "destination_participants";
    private JsonNullable<List<TransferParticipantBankModel>> destinationParticipants = JsonNullable.undefined();
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_TRANSFER_DETAILS = "transfer_details";
    private JsonNullable<Object> transferDetails = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PAYMENT_RAIL = "payment_rail";
    private JsonNullable<String> paymentRail = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ENTRIES = "entries";
    private JsonNullable<List<TransferEntryBankModel>> entries = JsonNullable.undefined();

    public TransferBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the transfer.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public TransferBankModel transferType(String transferType) {
        this.transferType = transferType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of transfer; one of funding, book, crypto, instant_funding, funding_return, crypto_return, loss_recovery, inter_account, lightning, or instant_funding_return.")
    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getTransferType() {
        return this.transferType;
    }

    @JsonProperty(value="transfer_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setTransferType(String transferType) {
        this.transferType = transferType;
    }

    public TransferBankModel bankGuid(String bankGuid) {
        this.bankGuid = JsonNullable.of((Object)bankGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated bank's identifier.")
    @JsonIgnore
    public String getBankGuid() {
        return (String)this.bankGuid.orElse(null);
    }

    @JsonProperty(value="bank_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getBankGuid_JsonNullable() {
        return this.bankGuid;
    }

    @JsonProperty(value="bank_guid")
    public void setBankGuid_JsonNullable(JsonNullable<String> bankGuid) {
        this.bankGuid = bankGuid;
    }

    public void setBankGuid(String bankGuid) {
        this.bankGuid = JsonNullable.of((Object)bankGuid);
    }

    public TransferBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated customer's identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public TransferBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public TransferBankModel externalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The associated external bank account's identifier.")
    @JsonIgnore
    public String getExternalBankAccountGuid() {
        return (String)this.externalBankAccountGuid.orElse(null);
    }

    @JsonProperty(value="external_bank_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExternalBankAccountGuid_JsonNullable() {
        return this.externalBankAccountGuid;
    }

    @JsonProperty(value="external_bank_account_guid")
    public void setExternalBankAccountGuid_JsonNullable(JsonNullable<String> externalBankAccountGuid) {
        this.externalBankAccountGuid = externalBankAccountGuid;
    }

    public void setExternalBankAccountGuid(String externalBankAccountGuid) {
        this.externalBankAccountGuid = JsonNullable.of((Object)externalBankAccountGuid);
    }

    public TransferBankModel asset(String asset) {
        this.asset = asset;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset the transfer is related to, e.g., USD.")
    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAsset() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAsset(String asset) {
        this.asset = asset;
    }

    public TransferBankModel side(String side) {
        this.side = side;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The direction of the quote; one of deposit or withdrawal.")
    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getSide() {
        return this.side;
    }

    @JsonProperty(value="side")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setSide(String side) {
        this.side = side;
    }

    public TransferBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the transfer; one of storing, pending, reviewing, completed, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public TransferBankModel failureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The failure code for failed transfers; one of non_sufficient_funds, refresh_required, party_name_invalid, payment_rail_invalid, compliance_rejection, cancelled, reversed, limit_exceeded, network_fee_too_low, amount_too_low, internal_error, or invalid_address.")
    @JsonIgnore
    public String getFailureCode() {
        return (String)this.failureCode.orElse(null);
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFailureCode_JsonNullable() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    public void setFailureCode_JsonNullable(JsonNullable<String> failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
    }

    public TransferBankModel returnCode(String returnCode) {
        this.returnCode = JsonNullable.of((Object)returnCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The return code for reversed transfers")
    @JsonIgnore
    public String getReturnCode() {
        return (String)this.returnCode.orElse(null);
    }

    @JsonProperty(value="return_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getReturnCode_JsonNullable() {
        return this.returnCode;
    }

    @JsonProperty(value="return_code")
    public void setReturnCode_JsonNullable(JsonNullable<String> returnCode) {
        this.returnCode = returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = JsonNullable.of((Object)returnCode);
    }

    public TransferBankModel amount(BigInteger amount) {
        this.amount = JsonNullable.of((Object)amount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The actual amount in base units of the asset.")
    @JsonIgnore
    public BigInteger getAmount() {
        return (BigInteger)this.amount.orElse(null);
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getAmount_JsonNullable() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    public void setAmount_JsonNullable(JsonNullable<BigInteger> amount) {
        this.amount = amount;
    }

    public void setAmount(BigInteger amount) {
        this.amount = JsonNullable.of((Object)amount);
    }

    public TransferBankModel estimatedAmount(BigInteger estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The estimated amount in base units of the asset.")
    @JsonProperty(value="estimated_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getEstimatedAmount() {
        return this.estimatedAmount;
    }

    @JsonProperty(value="estimated_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setEstimatedAmount(BigInteger estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    public TransferBankModel fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fee associated with the transfer.")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public BigInteger getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public TransferBankModel estimatedNetworkFee(BigInteger estimatedNetworkFee) {
        this.estimatedNetworkFee = JsonNullable.of((Object)estimatedNetworkFee);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The estimated network fee in base units of network_fee_asset. Only present on `crypto` transfers.")
    @JsonIgnore
    public BigInteger getEstimatedNetworkFee() {
        return (BigInteger)this.estimatedNetworkFee.orElse(null);
    }

    @JsonProperty(value="estimated_network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getEstimatedNetworkFee_JsonNullable() {
        return this.estimatedNetworkFee;
    }

    @JsonProperty(value="estimated_network_fee")
    public void setEstimatedNetworkFee_JsonNullable(JsonNullable<BigInteger> estimatedNetworkFee) {
        this.estimatedNetworkFee = estimatedNetworkFee;
    }

    public void setEstimatedNetworkFee(BigInteger estimatedNetworkFee) {
        this.estimatedNetworkFee = JsonNullable.of((Object)estimatedNetworkFee);
    }

    public TransferBankModel networkFee(BigInteger networkFee) {
        this.networkFee = JsonNullable.of((Object)networkFee);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The actual network fee in base units of network_fee_asset. Only present on `crypto` transfers that have successfully completed.")
    @JsonIgnore
    public BigInteger getNetworkFee() {
        return (BigInteger)this.networkFee.orElse(null);
    }

    @JsonProperty(value="network_fee")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getNetworkFee_JsonNullable() {
        return this.networkFee;
    }

    @JsonProperty(value="network_fee")
    public void setNetworkFee_JsonNullable(JsonNullable<BigInteger> networkFee) {
        this.networkFee = networkFee;
    }

    public void setNetworkFee(BigInteger networkFee) {
        this.networkFee = JsonNullable.of((Object)networkFee);
    }

    public TransferBankModel networkFeeAsset(String networkFeeAsset) {
        this.networkFeeAsset = JsonNullable.of((Object)networkFeeAsset);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code of the network fee. Only present on `crypto` transfers that have successfully completed.")
    @JsonIgnore
    public String getNetworkFeeAsset() {
        return (String)this.networkFeeAsset.orElse(null);
    }

    @JsonProperty(value="network_fee_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNetworkFeeAsset_JsonNullable() {
        return this.networkFeeAsset;
    }

    @JsonProperty(value="network_fee_asset")
    public void setNetworkFeeAsset_JsonNullable(JsonNullable<String> networkFeeAsset) {
        this.networkFeeAsset = networkFeeAsset;
    }

    public void setNetworkFeeAsset(String networkFeeAsset) {
        this.networkFeeAsset = JsonNullable.of((Object)networkFeeAsset);
    }

    public TransferBankModel networkFeeLiabilityAmount(BigInteger networkFeeLiabilityAmount) {
        this.networkFeeLiabilityAmount = JsonNullable.of((Object)networkFeeLiabilityAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The equivalent fiat network fee in base units of network_fee_liability_amount_asset. Only present on `crypto` transfers that have successfully completed.")
    @JsonIgnore
    public BigInteger getNetworkFeeLiabilityAmount() {
        return (BigInteger)this.networkFeeLiabilityAmount.orElse(null);
    }

    @JsonProperty(value="network_fee_liability_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getNetworkFeeLiabilityAmount_JsonNullable() {
        return this.networkFeeLiabilityAmount;
    }

    @JsonProperty(value="network_fee_liability_amount")
    public void setNetworkFeeLiabilityAmount_JsonNullable(JsonNullable<BigInteger> networkFeeLiabilityAmount) {
        this.networkFeeLiabilityAmount = networkFeeLiabilityAmount;
    }

    public void setNetworkFeeLiabilityAmount(BigInteger networkFeeLiabilityAmount) {
        this.networkFeeLiabilityAmount = JsonNullable.of((Object)networkFeeLiabilityAmount);
    }

    public TransferBankModel networkFeeLiabilityAmountAsset(String networkFeeLiabilityAmountAsset) {
        this.networkFeeLiabilityAmountAsset = JsonNullable.of((Object)networkFeeLiabilityAmountAsset);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The fiat asset the network_fee_liability_amount is denominated in. Only present on `crypto` transfers that have successfully completed.")
    @JsonIgnore
    public String getNetworkFeeLiabilityAmountAsset() {
        return (String)this.networkFeeLiabilityAmountAsset.orElse(null);
    }

    @JsonProperty(value="network_fee_liability_amount_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNetworkFeeLiabilityAmountAsset_JsonNullable() {
        return this.networkFeeLiabilityAmountAsset;
    }

    @JsonProperty(value="network_fee_liability_amount_asset")
    public void setNetworkFeeLiabilityAmountAsset_JsonNullable(JsonNullable<String> networkFeeLiabilityAmountAsset) {
        this.networkFeeLiabilityAmountAsset = networkFeeLiabilityAmountAsset;
    }

    public void setNetworkFeeLiabilityAmountAsset(String networkFeeLiabilityAmountAsset) {
        this.networkFeeLiabilityAmountAsset = JsonNullable.of((Object)networkFeeLiabilityAmountAsset);
    }

    public TransferBankModel txnHash(String txnHash) {
        this.txnHash = JsonNullable.of((Object)txnHash);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The hash of the blockchain transaction")
    @JsonIgnore
    public String getTxnHash() {
        return (String)this.txnHash.orElse(null);
    }

    @JsonProperty(value="txn_hash")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getTxnHash_JsonNullable() {
        return this.txnHash;
    }

    @JsonProperty(value="txn_hash")
    public void setTxnHash_JsonNullable(JsonNullable<String> txnHash) {
        this.txnHash = txnHash;
    }

    public void setTxnHash(String txnHash) {
        this.txnHash = JsonNullable.of((Object)txnHash);
    }

    public TransferBankModel referenceTransferGuid(String referenceTransferGuid) {
        this.referenceTransferGuid = JsonNullable.of((Object)referenceTransferGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The guid of the related transfer. Only present on return type transfers.")
    @JsonIgnore
    public String getReferenceTransferGuid() {
        return (String)this.referenceTransferGuid.orElse(null);
    }

    @JsonProperty(value="reference_transfer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getReferenceTransferGuid_JsonNullable() {
        return this.referenceTransferGuid;
    }

    @JsonProperty(value="reference_transfer_guid")
    public void setReferenceTransferGuid_JsonNullable(JsonNullable<String> referenceTransferGuid) {
        this.referenceTransferGuid = referenceTransferGuid;
    }

    public void setReferenceTransferGuid(String referenceTransferGuid) {
        this.referenceTransferGuid = JsonNullable.of((Object)referenceTransferGuid);
    }

    public TransferBankModel sourceAccount(TransferSourceAccountBankModel sourceAccount) {
        this.sourceAccount = JsonNullable.of((Object)sourceAccount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public TransferSourceAccountBankModel getSourceAccount() {
        return (TransferSourceAccountBankModel)this.sourceAccount.orElse(null);
    }

    @JsonProperty(value="source_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<TransferSourceAccountBankModel> getSourceAccount_JsonNullable() {
        return this.sourceAccount;
    }

    @JsonProperty(value="source_account")
    public void setSourceAccount_JsonNullable(JsonNullable<TransferSourceAccountBankModel> sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public void setSourceAccount(TransferSourceAccountBankModel sourceAccount) {
        this.sourceAccount = JsonNullable.of((Object)sourceAccount);
    }

    public TransferBankModel sourceParticipants(List<TransferParticipantBankModel> sourceParticipants) {
        this.sourceParticipants = JsonNullable.of(sourceParticipants);
        return this;
    }

    public TransferBankModel addSourceParticipantsItem(TransferParticipantBankModel sourceParticipantsItem) {
        if (this.sourceParticipants == null || !this.sourceParticipants.isPresent()) {
            this.sourceParticipants = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.sourceParticipants.get()).add(sourceParticipantsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The participants in the source account.")
    @JsonIgnore
    public List<TransferParticipantBankModel> getSourceParticipants() {
        return (List)this.sourceParticipants.orElse(null);
    }

    @JsonProperty(value="source_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<TransferParticipantBankModel>> getSourceParticipants_JsonNullable() {
        return this.sourceParticipants;
    }

    @JsonProperty(value="source_participants")
    public void setSourceParticipants_JsonNullable(JsonNullable<List<TransferParticipantBankModel>> sourceParticipants) {
        this.sourceParticipants = sourceParticipants;
    }

    public void setSourceParticipants(List<TransferParticipantBankModel> sourceParticipants) {
        this.sourceParticipants = JsonNullable.of(sourceParticipants);
    }

    public TransferBankModel destinationAccount(TransferDestinationAccountBankModel destinationAccount) {
        this.destinationAccount = JsonNullable.of((Object)destinationAccount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public TransferDestinationAccountBankModel getDestinationAccount() {
        return (TransferDestinationAccountBankModel)this.destinationAccount.orElse(null);
    }

    @JsonProperty(value="destination_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<TransferDestinationAccountBankModel> getDestinationAccount_JsonNullable() {
        return this.destinationAccount;
    }

    @JsonProperty(value="destination_account")
    public void setDestinationAccount_JsonNullable(JsonNullable<TransferDestinationAccountBankModel> destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public void setDestinationAccount(TransferDestinationAccountBankModel destinationAccount) {
        this.destinationAccount = JsonNullable.of((Object)destinationAccount);
    }

    public TransferBankModel destinationParticipants(List<TransferParticipantBankModel> destinationParticipants) {
        this.destinationParticipants = JsonNullable.of(destinationParticipants);
        return this;
    }

    public TransferBankModel addDestinationParticipantsItem(TransferParticipantBankModel destinationParticipantsItem) {
        if (this.destinationParticipants == null || !this.destinationParticipants.isPresent()) {
            this.destinationParticipants = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.destinationParticipants.get()).add(destinationParticipantsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The participants in the source account.")
    @JsonIgnore
    public List<TransferParticipantBankModel> getDestinationParticipants() {
        return (List)this.destinationParticipants.orElse(null);
    }

    @JsonProperty(value="destination_participants")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<TransferParticipantBankModel>> getDestinationParticipants_JsonNullable() {
        return this.destinationParticipants;
    }

    @JsonProperty(value="destination_participants")
    public void setDestinationParticipants_JsonNullable(JsonNullable<List<TransferParticipantBankModel>> destinationParticipants) {
        this.destinationParticipants = destinationParticipants;
    }

    public void setDestinationParticipants(List<TransferParticipantBankModel> destinationParticipants) {
        this.destinationParticipants = JsonNullable.of(destinationParticipants);
    }

    public TransferBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public TransferBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public TransferBankModel transferDetails(Object transferDetails) {
        this.transferDetails = JsonNullable.of((Object)transferDetails);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The raw details on the transfer from the bank.")
    @JsonIgnore
    public Object getTransferDetails() {
        return this.transferDetails.orElse(null);
    }

    @JsonProperty(value="transfer_details")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<Object> getTransferDetails_JsonNullable() {
        return this.transferDetails;
    }

    @JsonProperty(value="transfer_details")
    public void setTransferDetails_JsonNullable(JsonNullable<Object> transferDetails) {
        this.transferDetails = transferDetails;
    }

    public void setTransferDetails(Object transferDetails) {
        this.transferDetails = JsonNullable.of((Object)transferDetails);
    }

    public TransferBankModel paymentRail(String paymentRail) {
        this.paymentRail = JsonNullable.of((Object)paymentRail);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The rail the payment was done on. One of: ach, eft, wire, rtp")
    @JsonIgnore
    public String getPaymentRail() {
        return (String)this.paymentRail.orElse(null);
    }

    @JsonProperty(value="payment_rail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPaymentRail_JsonNullable() {
        return this.paymentRail;
    }

    @JsonProperty(value="payment_rail")
    public void setPaymentRail_JsonNullable(JsonNullable<String> paymentRail) {
        this.paymentRail = paymentRail;
    }

    public void setPaymentRail(String paymentRail) {
        this.paymentRail = JsonNullable.of((Object)paymentRail);
    }

    public TransferBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public TransferBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the transfer.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public TransferBankModel entries(List<TransferEntryBankModel> entries) {
        this.entries = JsonNullable.of(entries);
        return this;
    }

    public TransferBankModel addEntriesItem(TransferEntryBankModel entriesItem) {
        if (this.entries == null || !this.entries.isPresent()) {
            this.entries = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.entries.get()).add(entriesItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Transfer entries associated with the batch transfer")
    @JsonIgnore
    public List<TransferEntryBankModel> getEntries() {
        return (List)this.entries.orElse(null);
    }

    @JsonProperty(value="entries")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<TransferEntryBankModel>> getEntries_JsonNullable() {
        return this.entries;
    }

    @JsonProperty(value="entries")
    public void setEntries_JsonNullable(JsonNullable<List<TransferEntryBankModel>> entries) {
        this.entries = entries;
    }

    public void setEntries(List<TransferEntryBankModel> entries) {
        this.entries = JsonNullable.of(entries);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferBankModel transfer = (TransferBankModel)o;
        return Objects.equals(this.guid, transfer.guid) && Objects.equals(this.transferType, transfer.transferType) && TransferBankModel.equalsNullable(this.bankGuid, transfer.bankGuid) && TransferBankModel.equalsNullable(this.customerGuid, transfer.customerGuid) && Objects.equals(this.quoteGuid, transfer.quoteGuid) && TransferBankModel.equalsNullable(this.externalBankAccountGuid, transfer.externalBankAccountGuid) && Objects.equals(this.asset, transfer.asset) && Objects.equals(this.side, transfer.side) && Objects.equals(this.state, transfer.state) && TransferBankModel.equalsNullable(this.failureCode, transfer.failureCode) && TransferBankModel.equalsNullable(this.returnCode, transfer.returnCode) && TransferBankModel.equalsNullable(this.amount, transfer.amount) && Objects.equals(this.estimatedAmount, transfer.estimatedAmount) && Objects.equals(this.fee, transfer.fee) && TransferBankModel.equalsNullable(this.estimatedNetworkFee, transfer.estimatedNetworkFee) && TransferBankModel.equalsNullable(this.networkFee, transfer.networkFee) && TransferBankModel.equalsNullable(this.networkFeeAsset, transfer.networkFeeAsset) && TransferBankModel.equalsNullable(this.networkFeeLiabilityAmount, transfer.networkFeeLiabilityAmount) && TransferBankModel.equalsNullable(this.networkFeeLiabilityAmountAsset, transfer.networkFeeLiabilityAmountAsset) && TransferBankModel.equalsNullable(this.txnHash, transfer.txnHash) && TransferBankModel.equalsNullable(this.referenceTransferGuid, transfer.referenceTransferGuid) && TransferBankModel.equalsNullable(this.sourceAccount, transfer.sourceAccount) && TransferBankModel.equalsNullable(this.sourceParticipants, transfer.sourceParticipants) && TransferBankModel.equalsNullable(this.destinationAccount, transfer.destinationAccount) && TransferBankModel.equalsNullable(this.destinationParticipants, transfer.destinationParticipants) && Objects.equals(this.createdAt, transfer.createdAt) && Objects.equals(this.updatedAt, transfer.updatedAt) && TransferBankModel.equalsNullable(this.transferDetails, transfer.transferDetails) && TransferBankModel.equalsNullable(this.paymentRail, transfer.paymentRail) && TransferBankModel.equalsNullable(this.labels, transfer.labels) && TransferBankModel.equalsNullable(this.entries, transfer.entries);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, this.transferType, TransferBankModel.hashCodeNullable(this.bankGuid), TransferBankModel.hashCodeNullable(this.customerGuid), this.quoteGuid, TransferBankModel.hashCodeNullable(this.externalBankAccountGuid), this.asset, this.side, this.state, TransferBankModel.hashCodeNullable(this.failureCode), TransferBankModel.hashCodeNullable(this.returnCode), TransferBankModel.hashCodeNullable(this.amount), this.estimatedAmount, this.fee, TransferBankModel.hashCodeNullable(this.estimatedNetworkFee), TransferBankModel.hashCodeNullable(this.networkFee), TransferBankModel.hashCodeNullable(this.networkFeeAsset), TransferBankModel.hashCodeNullable(this.networkFeeLiabilityAmount), TransferBankModel.hashCodeNullable(this.networkFeeLiabilityAmountAsset), TransferBankModel.hashCodeNullable(this.txnHash), TransferBankModel.hashCodeNullable(this.referenceTransferGuid), TransferBankModel.hashCodeNullable(this.sourceAccount), TransferBankModel.hashCodeNullable(this.sourceParticipants), TransferBankModel.hashCodeNullable(this.destinationAccount), TransferBankModel.hashCodeNullable(this.destinationParticipants), this.createdAt, this.updatedAt, TransferBankModel.hashCodeNullable(this.transferDetails), TransferBankModel.hashCodeNullable(this.paymentRail), TransferBankModel.hashCodeNullable(this.labels), TransferBankModel.hashCodeNullable(this.entries));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    transferType: ").append(this.toIndentedString(this.transferType)).append("\n");
        sb.append("    bankGuid: ").append(this.toIndentedString(this.bankGuid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    externalBankAccountGuid: ").append(this.toIndentedString(this.externalBankAccountGuid)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    side: ").append(this.toIndentedString(this.side)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    returnCode: ").append(this.toIndentedString(this.returnCode)).append("\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    estimatedAmount: ").append(this.toIndentedString(this.estimatedAmount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    estimatedNetworkFee: ").append(this.toIndentedString(this.estimatedNetworkFee)).append("\n");
        sb.append("    networkFee: ").append(this.toIndentedString(this.networkFee)).append("\n");
        sb.append("    networkFeeAsset: ").append(this.toIndentedString(this.networkFeeAsset)).append("\n");
        sb.append("    networkFeeLiabilityAmount: ").append(this.toIndentedString(this.networkFeeLiabilityAmount)).append("\n");
        sb.append("    networkFeeLiabilityAmountAsset: ").append(this.toIndentedString(this.networkFeeLiabilityAmountAsset)).append("\n");
        sb.append("    txnHash: ").append(this.toIndentedString(this.txnHash)).append("\n");
        sb.append("    referenceTransferGuid: ").append(this.toIndentedString(this.referenceTransferGuid)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    sourceParticipants: ").append(this.toIndentedString(this.sourceParticipants)).append("\n");
        sb.append("    destinationAccount: ").append(this.toIndentedString(this.destinationAccount)).append("\n");
        sb.append("    destinationParticipants: ").append(this.toIndentedString(this.destinationParticipants)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    transferDetails: ").append(this.toIndentedString(this.transferDetails)).append("\n");
        sb.append("    paymentRail: ").append(this.toIndentedString(this.paymentRail)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("    entries: ").append(this.toIndentedString(this.entries)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

