/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.QuoteEntrySourceAccountBankModel;
import app.cybrid.cybrid_api_bank.client.model.TransferEntryDestinationAccountBankModel;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"amount", "fee", "source_account", "destination_account"})
@JsonTypeName(value="TransferEntry")
public class TransferEntryBankModel {
    public static final String JSON_PROPERTY_AMOUNT = "amount";
    private BigInteger amount;
    public static final String JSON_PROPERTY_FEE = "fee";
    private BigInteger fee;
    public static final String JSON_PROPERTY_SOURCE_ACCOUNT = "source_account";
    private QuoteEntrySourceAccountBankModel sourceAccount;
    public static final String JSON_PROPERTY_DESTINATION_ACCOUNT = "destination_account";
    private TransferEntryDestinationAccountBankModel destinationAccount;

    public TransferEntryBankModel amount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The actual amount in base units of the asset.")
    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigInteger getAmount() {
        return this.amount;
    }

    @JsonProperty(value="amount")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAmount(BigInteger amount) {
        this.amount = amount;
    }

    public TransferEntryBankModel fee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The fee associated with the transfer entry.")
    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public BigInteger getFee() {
        return this.fee;
    }

    @JsonProperty(value="fee")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setFee(BigInteger fee) {
        this.fee = fee;
    }

    public TransferEntryBankModel sourceAccount(QuoteEntrySourceAccountBankModel sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="source_account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public QuoteEntrySourceAccountBankModel getSourceAccount() {
        return this.sourceAccount;
    }

    @JsonProperty(value="source_account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSourceAccount(QuoteEntrySourceAccountBankModel sourceAccount) {
        this.sourceAccount = sourceAccount;
    }

    public TransferEntryBankModel destinationAccount(TransferEntryDestinationAccountBankModel destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="destination_account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public TransferEntryDestinationAccountBankModel getDestinationAccount() {
        return this.destinationAccount;
    }

    @JsonProperty(value="destination_account")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setDestinationAccount(TransferEntryDestinationAccountBankModel destinationAccount) {
        this.destinationAccount = destinationAccount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferEntryBankModel transferEntry = (TransferEntryBankModel)o;
        return Objects.equals(this.amount, transferEntry.amount) && Objects.equals(this.fee, transferEntry.fee) && Objects.equals(this.sourceAccount, transferEntry.sourceAccount) && Objects.equals(this.destinationAccount, transferEntry.destinationAccount);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.fee, this.sourceAccount, this.destinationAccount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferEntryBankModel {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    fee: ").append(this.toIndentedString(this.fee)).append("\n");
        sb.append("    sourceAccount: ").append(this.toIndentedString(this.sourceAccount)).append("\n");
        sb.append("    destinationAccount: ").append(this.toIndentedString(this.destinationAccount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

