/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigInteger;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@JsonPropertyOrder(value={"guid", "customer_guid", "invoice_guid", "created_at", "updated_at", "expired_at", "failed_at", "network_address", "expected_payment_asset", "expected_payment_amount", "failure_code", "state"})
@JsonTypeName(value="PaymentInstruction")
public class PaymentInstructionBankModel {
    public static final String JSON_PROPERTY_GUID = "guid";
    private String guid;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_INVOICE_GUID = "invoice_guid";
    private String invoiceGuid;
    public static final String JSON_PROPERTY_CREATED_AT = "created_at";
    private OffsetDateTime createdAt;
    public static final String JSON_PROPERTY_UPDATED_AT = "updated_at";
    private OffsetDateTime updatedAt;
    public static final String JSON_PROPERTY_EXPIRED_AT = "expired_at";
    private JsonNullable<OffsetDateTime> expiredAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FAILED_AT = "failed_at";
    private JsonNullable<OffsetDateTime> failedAt = JsonNullable.undefined();
    public static final String JSON_PROPERTY_NETWORK_ADDRESS = "network_address";
    private JsonNullable<String> networkAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPECTED_PAYMENT_ASSET = "expected_payment_asset";
    private JsonNullable<String> expectedPaymentAsset = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPECTED_PAYMENT_AMOUNT = "expected_payment_amount";
    private JsonNullable<BigInteger> expectedPaymentAmount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_FAILURE_CODE = "failure_code";
    private JsonNullable<String> failureCode = JsonNullable.undefined();
    public static final String JSON_PROPERTY_STATE = "state";
    private String state;

    public PaymentInstructionBankModel guid(String guid) {
        this.guid = guid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Auto-generated unique identifier for the payment instruction.")
    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getGuid() {
        return this.guid;
    }

    @JsonProperty(value="guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setGuid(String guid) {
        this.guid = guid;
    }

    public PaymentInstructionBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PaymentInstructionBankModel invoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The invoice identifier.")
    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getInvoiceGuid() {
        return this.invoiceGuid;
    }

    @JsonProperty(value="invoice_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setInvoiceGuid(String invoiceGuid) {
        this.invoiceGuid = invoiceGuid;
    }

    public PaymentInstructionBankModel createdAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was created at.")
    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    @JsonProperty(value="created_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
    }

    public PaymentInstructionBankModel updatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the record was last updated at.")
    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    @JsonProperty(value="updated_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setUpdatedAt(OffsetDateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    public PaymentInstructionBankModel expiredAt(OffsetDateTime expiredAt) {
        this.expiredAt = JsonNullable.of((Object)expiredAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the instructions expired at.")
    @JsonIgnore
    public OffsetDateTime getExpiredAt() {
        return (OffsetDateTime)this.expiredAt.orElse(null);
    }

    @JsonProperty(value="expired_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getExpiredAt_JsonNullable() {
        return this.expiredAt;
    }

    @JsonProperty(value="expired_at")
    public void setExpiredAt_JsonNullable(JsonNullable<OffsetDateTime> expiredAt) {
        this.expiredAt = expiredAt;
    }

    public void setExpiredAt(OffsetDateTime expiredAt) {
        this.expiredAt = JsonNullable.of((Object)expiredAt);
    }

    public PaymentInstructionBankModel failedAt(OffsetDateTime failedAt) {
        this.failedAt = JsonNullable.of((Object)failedAt);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO8601 datetime the instructions failed to be created at.")
    @JsonIgnore
    public OffsetDateTime getFailedAt() {
        return (OffsetDateTime)this.failedAt.orElse(null);
    }

    @JsonProperty(value="failed_at")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<OffsetDateTime> getFailedAt_JsonNullable() {
        return this.failedAt;
    }

    @JsonProperty(value="failed_at")
    public void setFailedAt_JsonNullable(JsonNullable<OffsetDateTime> failedAt) {
        this.failedAt = failedAt;
    }

    public void setFailedAt(OffsetDateTime failedAt) {
        this.failedAt = JsonNullable.of((Object)failedAt);
    }

    public PaymentInstructionBankModel networkAddress(String networkAddress) {
        this.networkAddress = JsonNullable.of((Object)networkAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The network address to pay the invoice to.")
    @JsonIgnore
    public String getNetworkAddress() {
        return (String)this.networkAddress.orElse(null);
    }

    @JsonProperty(value="network_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getNetworkAddress_JsonNullable() {
        return this.networkAddress;
    }

    @JsonProperty(value="network_address")
    public void setNetworkAddress_JsonNullable(JsonNullable<String> networkAddress) {
        this.networkAddress = networkAddress;
    }

    public void setNetworkAddress(String networkAddress) {
        this.networkAddress = JsonNullable.of((Object)networkAddress);
    }

    public PaymentInstructionBankModel expectedPaymentAsset(String expectedPaymentAsset) {
        this.expectedPaymentAsset = JsonNullable.of((Object)expectedPaymentAsset);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset the payor must pay the invoice in, e.g., BTC.")
    @JsonIgnore
    public String getExpectedPaymentAsset() {
        return (String)this.expectedPaymentAsset.orElse(null);
    }

    @JsonProperty(value="expected_payment_asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getExpectedPaymentAsset_JsonNullable() {
        return this.expectedPaymentAsset;
    }

    @JsonProperty(value="expected_payment_asset")
    public void setExpectedPaymentAsset_JsonNullable(JsonNullable<String> expectedPaymentAsset) {
        this.expectedPaymentAsset = expectedPaymentAsset;
    }

    public void setExpectedPaymentAsset(String expectedPaymentAsset) {
        this.expectedPaymentAsset = JsonNullable.of((Object)expectedPaymentAsset);
    }

    public PaymentInstructionBankModel expectedPaymentAmount(BigInteger expectedPaymentAmount) {
        this.expectedPaymentAmount = JsonNullable.of((Object)expectedPaymentAmount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The amount to be paid in base units of expected_payment_asset.")
    @JsonIgnore
    public BigInteger getExpectedPaymentAmount() {
        return (BigInteger)this.expectedPaymentAmount.orElse(null);
    }

    @JsonProperty(value="expected_payment_amount")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<BigInteger> getExpectedPaymentAmount_JsonNullable() {
        return this.expectedPaymentAmount;
    }

    @JsonProperty(value="expected_payment_amount")
    public void setExpectedPaymentAmount_JsonNullable(JsonNullable<BigInteger> expectedPaymentAmount) {
        this.expectedPaymentAmount = expectedPaymentAmount;
    }

    public void setExpectedPaymentAmount(BigInteger expectedPaymentAmount) {
        this.expectedPaymentAmount = JsonNullable.of((Object)expectedPaymentAmount);
    }

    public PaymentInstructionBankModel failureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The reason code explaining the failure; ond of invoice_paid, invoice_cancelled, or invalid_amount.")
    @JsonIgnore
    public String getFailureCode() {
        return (String)this.failureCode.orElse(null);
    }

    @JsonProperty(value="failure_code")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFailureCode_JsonNullable() {
        return this.failureCode;
    }

    @JsonProperty(value="failure_code")
    public void setFailureCode_JsonNullable(JsonNullable<String> failureCode) {
        this.failureCode = failureCode;
    }

    public void setFailureCode(String failureCode) {
        this.failureCode = JsonNullable.of((Object)failureCode);
    }

    public PaymentInstructionBankModel state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The state of the payment instruction; one of storing, created, expired, or failed.")
    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getState() {
        return this.state;
    }

    @JsonProperty(value="state")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setState(String state) {
        this.state = state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInstructionBankModel paymentInstruction = (PaymentInstructionBankModel)o;
        return Objects.equals(this.guid, paymentInstruction.guid) && PaymentInstructionBankModel.equalsNullable(this.customerGuid, paymentInstruction.customerGuid) && Objects.equals(this.invoiceGuid, paymentInstruction.invoiceGuid) && Objects.equals(this.createdAt, paymentInstruction.createdAt) && Objects.equals(this.updatedAt, paymentInstruction.updatedAt) && PaymentInstructionBankModel.equalsNullable(this.expiredAt, paymentInstruction.expiredAt) && PaymentInstructionBankModel.equalsNullable(this.failedAt, paymentInstruction.failedAt) && PaymentInstructionBankModel.equalsNullable(this.networkAddress, paymentInstruction.networkAddress) && PaymentInstructionBankModel.equalsNullable(this.expectedPaymentAsset, paymentInstruction.expectedPaymentAsset) && PaymentInstructionBankModel.equalsNullable(this.expectedPaymentAmount, paymentInstruction.expectedPaymentAmount) && PaymentInstructionBankModel.equalsNullable(this.failureCode, paymentInstruction.failureCode) && Objects.equals(this.state, paymentInstruction.state);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(this.guid, PaymentInstructionBankModel.hashCodeNullable(this.customerGuid), this.invoiceGuid, this.createdAt, this.updatedAt, PaymentInstructionBankModel.hashCodeNullable(this.expiredAt), PaymentInstructionBankModel.hashCodeNullable(this.failedAt), PaymentInstructionBankModel.hashCodeNullable(this.networkAddress), PaymentInstructionBankModel.hashCodeNullable(this.expectedPaymentAsset), PaymentInstructionBankModel.hashCodeNullable(this.expectedPaymentAmount), PaymentInstructionBankModel.hashCodeNullable(this.failureCode), this.state);
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInstructionBankModel {\n");
        sb.append("    guid: ").append(this.toIndentedString(this.guid)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    invoiceGuid: ").append(this.toIndentedString(this.invoiceGuid)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    updatedAt: ").append(this.toIndentedString(this.updatedAt)).append("\n");
        sb.append("    expiredAt: ").append(this.toIndentedString(this.expiredAt)).append("\n");
        sb.append("    failedAt: ").append(this.toIndentedString(this.failedAt)).append("\n");
        sb.append("    networkAddress: ").append(this.toIndentedString(this.networkAddress)).append("\n");
        sb.append("    expectedPaymentAsset: ").append(this.toIndentedString(this.expectedPaymentAsset)).append("\n");
        sb.append("    expectedPaymentAmount: ").append(this.toIndentedString(this.expectedPaymentAmount)).append("\n");
        sb.append("    failureCode: ").append(this.toIndentedString(this.failureCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

