/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import app.cybrid.cybrid_api_bank.client.model.PostExternalBankAccountCounterpartyAddressBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostExternalBankAccountCounterpartyBankAccountBankModel;
import app.cybrid.cybrid_api_bank.client.model.PostExternalBankAccountCounterpartyNameBankModel;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for external bank account creation.")
@JsonPropertyOrder(value={"name", "account_kind", "customer_guid", "asset", "plaid_public_token", "plaid_account_id", "plaid_processor_token", "plaid_institution_id", "plaid_account_mask", "plaid_account_name", "counterparty_guid", "counterparty_bank_account", "counterparty_name", "counterparty_address", "counterparty_email_address"})
@JsonTypeName(value="PostExternalBankAccount")
public class PostExternalBankAccountBankModel {
    public static final String JSON_PROPERTY_NAME = "name";
    private String name;
    public static final String JSON_PROPERTY_ACCOUNT_KIND = "account_kind";
    private AccountKindEnum accountKind;
    public static final String JSON_PROPERTY_CUSTOMER_GUID = "customer_guid";
    private JsonNullable<String> customerGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_ASSET = "asset";
    private JsonNullable<String> asset = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PLAID_PUBLIC_TOKEN = "plaid_public_token";
    private JsonNullable<String> plaidPublicToken = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PLAID_ACCOUNT_ID = "plaid_account_id";
    private JsonNullable<String> plaidAccountId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PLAID_PROCESSOR_TOKEN = "plaid_processor_token";
    private JsonNullable<String> plaidProcessorToken = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PLAID_INSTITUTION_ID = "plaid_institution_id";
    private JsonNullable<String> plaidInstitutionId = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PLAID_ACCOUNT_MASK = "plaid_account_mask";
    private JsonNullable<String> plaidAccountMask = JsonNullable.undefined();
    public static final String JSON_PROPERTY_PLAID_ACCOUNT_NAME = "plaid_account_name";
    private JsonNullable<String> plaidAccountName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_GUID = "counterparty_guid";
    private JsonNullable<String> counterpartyGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_BANK_ACCOUNT = "counterparty_bank_account";
    private JsonNullable<PostExternalBankAccountCounterpartyBankAccountBankModel> counterpartyBankAccount = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_NAME = "counterparty_name";
    private JsonNullable<PostExternalBankAccountCounterpartyNameBankModel> counterpartyName = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_ADDRESS = "counterparty_address";
    private JsonNullable<PostExternalBankAccountCounterpartyAddressBankModel> counterpartyAddress = JsonNullable.undefined();
    public static final String JSON_PROPERTY_COUNTERPARTY_EMAIL_ADDRESS = "counterparty_email_address";
    private JsonNullable<String> counterpartyEmailAddress = JsonNullable.undefined();

    public PostExternalBankAccountBankModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The name of the account.")
    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setName(String name) {
        this.name = name;
    }

    public PostExternalBankAccountBankModel accountKind(AccountKindEnum accountKind) {
        this.accountKind = accountKind;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The account type")
    @JsonProperty(value="account_kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public AccountKindEnum getAccountKind() {
        return this.accountKind;
    }

    @JsonProperty(value="account_kind")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAccountKind(AccountKindEnum accountKind) {
        this.accountKind = accountKind;
    }

    public PostExternalBankAccountBankModel customerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The customer identifier.")
    @JsonIgnore
    public String getCustomerGuid() {
        return (String)this.customerGuid.orElse(null);
    }

    @JsonProperty(value="customer_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCustomerGuid_JsonNullable() {
        return this.customerGuid;
    }

    @JsonProperty(value="customer_guid")
    public void setCustomerGuid_JsonNullable(JsonNullable<String> customerGuid) {
        this.customerGuid = customerGuid;
    }

    public void setCustomerGuid(String customerGuid) {
        this.customerGuid = JsonNullable.of((Object)customerGuid);
    }

    public PostExternalBankAccountBankModel asset(String asset) {
        this.asset = JsonNullable.of((Object)asset);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The asset code. If not set will try and default to the Bank's configured fiat asset.")
    @JsonIgnore
    public String getAsset() {
        return (String)this.asset.orElse(null);
    }

    @JsonProperty(value="asset")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getAsset_JsonNullable() {
        return this.asset;
    }

    @JsonProperty(value="asset")
    public void setAsset_JsonNullable(JsonNullable<String> asset) {
        this.asset = asset;
    }

    public void setAsset(String asset) {
        this.asset = JsonNullable.of((Object)asset);
    }

    public PostExternalBankAccountBankModel plaidPublicToken(String plaidPublicToken) {
        this.plaidPublicToken = JsonNullable.of((Object)plaidPublicToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The public token for the account. Required for 'plaid' accounts. Required when account_kind is plaid.")
    @JsonIgnore
    public String getPlaidPublicToken() {
        return (String)this.plaidPublicToken.orElse(null);
    }

    @JsonProperty(value="plaid_public_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidPublicToken_JsonNullable() {
        return this.plaidPublicToken;
    }

    @JsonProperty(value="plaid_public_token")
    public void setPlaidPublicToken_JsonNullable(JsonNullable<String> plaidPublicToken) {
        this.plaidPublicToken = plaidPublicToken;
    }

    public void setPlaidPublicToken(String plaidPublicToken) {
        this.plaidPublicToken = JsonNullable.of((Object)plaidPublicToken);
    }

    public PostExternalBankAccountBankModel plaidAccountId(String plaidAccountId) {
        this.plaidAccountId = JsonNullable.of((Object)plaidAccountId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account identifier in plaid. Required for 'plaid' accounts. Required when account_kind is plaid.")
    @JsonIgnore
    public String getPlaidAccountId() {
        return (String)this.plaidAccountId.orElse(null);
    }

    @JsonProperty(value="plaid_account_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidAccountId_JsonNullable() {
        return this.plaidAccountId;
    }

    @JsonProperty(value="plaid_account_id")
    public void setPlaidAccountId_JsonNullable(JsonNullable<String> plaidAccountId) {
        this.plaidAccountId = plaidAccountId;
    }

    public void setPlaidAccountId(String plaidAccountId) {
        this.plaidAccountId = JsonNullable.of((Object)plaidAccountId);
    }

    public PostExternalBankAccountBankModel plaidProcessorToken(String plaidProcessorToken) {
        this.plaidProcessorToken = JsonNullable.of((Object)plaidProcessorToken);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid processor token used to access the account. Required when account_kind is plaid_processor_token.")
    @JsonIgnore
    public String getPlaidProcessorToken() {
        return (String)this.plaidProcessorToken.orElse(null);
    }

    @JsonProperty(value="plaid_processor_token")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidProcessorToken_JsonNullable() {
        return this.plaidProcessorToken;
    }

    @JsonProperty(value="plaid_processor_token")
    public void setPlaidProcessorToken_JsonNullable(JsonNullable<String> plaidProcessorToken) {
        this.plaidProcessorToken = plaidProcessorToken;
    }

    public void setPlaidProcessorToken(String plaidProcessorToken) {
        this.plaidProcessorToken = JsonNullable.of((Object)plaidProcessorToken);
    }

    public PostExternalBankAccountBankModel plaidInstitutionId(String plaidInstitutionId) {
        this.plaidInstitutionId = JsonNullable.of((Object)plaidInstitutionId);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Plaid's institution ID for the account's institution. Required when account_kind is plaid_processor_token.")
    @JsonIgnore
    public String getPlaidInstitutionId() {
        return (String)this.plaidInstitutionId.orElse(null);
    }

    @JsonProperty(value="plaid_institution_id")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidInstitutionId_JsonNullable() {
        return this.plaidInstitutionId;
    }

    @JsonProperty(value="plaid_institution_id")
    public void setPlaidInstitutionId_JsonNullable(JsonNullable<String> plaidInstitutionId) {
        this.plaidInstitutionId = plaidInstitutionId;
    }

    public void setPlaidInstitutionId(String plaidInstitutionId) {
        this.plaidInstitutionId = JsonNullable.of((Object)plaidInstitutionId);
    }

    public PostExternalBankAccountBankModel plaidAccountMask(String plaidAccountMask) {
        this.plaidAccountMask = JsonNullable.of((Object)plaidAccountMask);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The account mask for the account. Required when account_kind is plaid_processor_token.")
    @JsonIgnore
    public String getPlaidAccountMask() {
        return (String)this.plaidAccountMask.orElse(null);
    }

    @JsonProperty(value="plaid_account_mask")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidAccountMask_JsonNullable() {
        return this.plaidAccountMask;
    }

    @JsonProperty(value="plaid_account_mask")
    public void setPlaidAccountMask_JsonNullable(JsonNullable<String> plaidAccountMask) {
        this.plaidAccountMask = plaidAccountMask;
    }

    public void setPlaidAccountMask(String plaidAccountMask) {
        this.plaidAccountMask = JsonNullable.of((Object)plaidAccountMask);
    }

    public PostExternalBankAccountBankModel plaidAccountName(String plaidAccountName) {
        this.plaidAccountName = JsonNullable.of((Object)plaidAccountName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the account. Required when account_kind is plaid_processor_token.")
    @JsonIgnore
    public String getPlaidAccountName() {
        return (String)this.plaidAccountName.orElse(null);
    }

    @JsonProperty(value="plaid_account_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getPlaidAccountName_JsonNullable() {
        return this.plaidAccountName;
    }

    @JsonProperty(value="plaid_account_name")
    public void setPlaidAccountName_JsonNullable(JsonNullable<String> plaidAccountName) {
        this.plaidAccountName = plaidAccountName;
    }

    public void setPlaidAccountName(String plaidAccountName) {
        this.plaidAccountName = JsonNullable.of((Object)plaidAccountName);
    }

    public PostExternalBankAccountBankModel counterpartyGuid(String counterpartyGuid) {
        this.counterpartyGuid = JsonNullable.of((Object)counterpartyGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty identifier. Optional when account_kind is raw_routing_details.")
    @JsonIgnore
    public String getCounterpartyGuid() {
        return (String)this.counterpartyGuid.orElse(null);
    }

    @JsonProperty(value="counterparty_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCounterpartyGuid_JsonNullable() {
        return this.counterpartyGuid;
    }

    @JsonProperty(value="counterparty_guid")
    public void setCounterpartyGuid_JsonNullable(JsonNullable<String> counterpartyGuid) {
        this.counterpartyGuid = counterpartyGuid;
    }

    public void setCounterpartyGuid(String counterpartyGuid) {
        this.counterpartyGuid = JsonNullable.of((Object)counterpartyGuid);
    }

    public PostExternalBankAccountBankModel counterpartyBankAccount(PostExternalBankAccountCounterpartyBankAccountBankModel counterpartyBankAccount) {
        this.counterpartyBankAccount = JsonNullable.of((Object)counterpartyBankAccount);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostExternalBankAccountCounterpartyBankAccountBankModel getCounterpartyBankAccount() {
        return (PostExternalBankAccountCounterpartyBankAccountBankModel)this.counterpartyBankAccount.orElse(null);
    }

    @JsonProperty(value="counterparty_bank_account")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostExternalBankAccountCounterpartyBankAccountBankModel> getCounterpartyBankAccount_JsonNullable() {
        return this.counterpartyBankAccount;
    }

    @JsonProperty(value="counterparty_bank_account")
    public void setCounterpartyBankAccount_JsonNullable(JsonNullable<PostExternalBankAccountCounterpartyBankAccountBankModel> counterpartyBankAccount) {
        this.counterpartyBankAccount = counterpartyBankAccount;
    }

    public void setCounterpartyBankAccount(PostExternalBankAccountCounterpartyBankAccountBankModel counterpartyBankAccount) {
        this.counterpartyBankAccount = JsonNullable.of((Object)counterpartyBankAccount);
    }

    public PostExternalBankAccountBankModel counterpartyName(PostExternalBankAccountCounterpartyNameBankModel counterpartyName) {
        this.counterpartyName = JsonNullable.of((Object)counterpartyName);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostExternalBankAccountCounterpartyNameBankModel getCounterpartyName() {
        return (PostExternalBankAccountCounterpartyNameBankModel)this.counterpartyName.orElse(null);
    }

    @JsonProperty(value="counterparty_name")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostExternalBankAccountCounterpartyNameBankModel> getCounterpartyName_JsonNullable() {
        return this.counterpartyName;
    }

    @JsonProperty(value="counterparty_name")
    public void setCounterpartyName_JsonNullable(JsonNullable<PostExternalBankAccountCounterpartyNameBankModel> counterpartyName) {
        this.counterpartyName = counterpartyName;
    }

    public void setCounterpartyName(PostExternalBankAccountCounterpartyNameBankModel counterpartyName) {
        this.counterpartyName = JsonNullable.of((Object)counterpartyName);
    }

    public PostExternalBankAccountBankModel counterpartyAddress(PostExternalBankAccountCounterpartyAddressBankModel counterpartyAddress) {
        this.counterpartyAddress = JsonNullable.of((Object)counterpartyAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    @JsonIgnore
    public PostExternalBankAccountCounterpartyAddressBankModel getCounterpartyAddress() {
        return (PostExternalBankAccountCounterpartyAddressBankModel)this.counterpartyAddress.orElse(null);
    }

    @JsonProperty(value="counterparty_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<PostExternalBankAccountCounterpartyAddressBankModel> getCounterpartyAddress_JsonNullable() {
        return this.counterpartyAddress;
    }

    @JsonProperty(value="counterparty_address")
    public void setCounterpartyAddress_JsonNullable(JsonNullable<PostExternalBankAccountCounterpartyAddressBankModel> counterpartyAddress) {
        this.counterpartyAddress = counterpartyAddress;
    }

    public void setCounterpartyAddress(PostExternalBankAccountCounterpartyAddressBankModel counterpartyAddress) {
        this.counterpartyAddress = JsonNullable.of((Object)counterpartyAddress);
    }

    public PostExternalBankAccountBankModel counterpartyEmailAddress(String counterpartyEmailAddress) {
        this.counterpartyEmailAddress = JsonNullable.of((Object)counterpartyEmailAddress);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparty's email address on their checking account. Optional when account_kind is raw_routing_details and counterparty_guid is not present.")
    @JsonIgnore
    public String getCounterpartyEmailAddress() {
        return (String)this.counterpartyEmailAddress.orElse(null);
    }

    @JsonProperty(value="counterparty_email_address")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getCounterpartyEmailAddress_JsonNullable() {
        return this.counterpartyEmailAddress;
    }

    @JsonProperty(value="counterparty_email_address")
    public void setCounterpartyEmailAddress_JsonNullable(JsonNullable<String> counterpartyEmailAddress) {
        this.counterpartyEmailAddress = counterpartyEmailAddress;
    }

    public void setCounterpartyEmailAddress(String counterpartyEmailAddress) {
        this.counterpartyEmailAddress = JsonNullable.of((Object)counterpartyEmailAddress);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostExternalBankAccountBankModel postExternalBankAccount = (PostExternalBankAccountBankModel)o;
        return Objects.equals(this.name, postExternalBankAccount.name) && Objects.equals((Object)this.accountKind, (Object)postExternalBankAccount.accountKind) && PostExternalBankAccountBankModel.equalsNullable(this.customerGuid, postExternalBankAccount.customerGuid) && PostExternalBankAccountBankModel.equalsNullable(this.asset, postExternalBankAccount.asset) && PostExternalBankAccountBankModel.equalsNullable(this.plaidPublicToken, postExternalBankAccount.plaidPublicToken) && PostExternalBankAccountBankModel.equalsNullable(this.plaidAccountId, postExternalBankAccount.plaidAccountId) && PostExternalBankAccountBankModel.equalsNullable(this.plaidProcessorToken, postExternalBankAccount.plaidProcessorToken) && PostExternalBankAccountBankModel.equalsNullable(this.plaidInstitutionId, postExternalBankAccount.plaidInstitutionId) && PostExternalBankAccountBankModel.equalsNullable(this.plaidAccountMask, postExternalBankAccount.plaidAccountMask) && PostExternalBankAccountBankModel.equalsNullable(this.plaidAccountName, postExternalBankAccount.plaidAccountName) && PostExternalBankAccountBankModel.equalsNullable(this.counterpartyGuid, postExternalBankAccount.counterpartyGuid) && PostExternalBankAccountBankModel.equalsNullable(this.counterpartyBankAccount, postExternalBankAccount.counterpartyBankAccount) && PostExternalBankAccountBankModel.equalsNullable(this.counterpartyName, postExternalBankAccount.counterpartyName) && PostExternalBankAccountBankModel.equalsNullable(this.counterpartyAddress, postExternalBankAccount.counterpartyAddress) && PostExternalBankAccountBankModel.equalsNullable(this.counterpartyEmailAddress, postExternalBankAccount.counterpartyEmailAddress);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.accountKind, PostExternalBankAccountBankModel.hashCodeNullable(this.customerGuid), PostExternalBankAccountBankModel.hashCodeNullable(this.asset), PostExternalBankAccountBankModel.hashCodeNullable(this.plaidPublicToken), PostExternalBankAccountBankModel.hashCodeNullable(this.plaidAccountId), PostExternalBankAccountBankModel.hashCodeNullable(this.plaidProcessorToken), PostExternalBankAccountBankModel.hashCodeNullable(this.plaidInstitutionId), PostExternalBankAccountBankModel.hashCodeNullable(this.plaidAccountMask), PostExternalBankAccountBankModel.hashCodeNullable(this.plaidAccountName), PostExternalBankAccountBankModel.hashCodeNullable(this.counterpartyGuid), PostExternalBankAccountBankModel.hashCodeNullable(this.counterpartyBankAccount), PostExternalBankAccountBankModel.hashCodeNullable(this.counterpartyName), PostExternalBankAccountBankModel.hashCodeNullable(this.counterpartyAddress), PostExternalBankAccountBankModel.hashCodeNullable(this.counterpartyEmailAddress)});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostExternalBankAccountBankModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    accountKind: ").append(this.toIndentedString((Object)this.accountKind)).append("\n");
        sb.append("    customerGuid: ").append(this.toIndentedString(this.customerGuid)).append("\n");
        sb.append("    asset: ").append(this.toIndentedString(this.asset)).append("\n");
        sb.append("    plaidPublicToken: ").append(this.toIndentedString(this.plaidPublicToken)).append("\n");
        sb.append("    plaidAccountId: ").append(this.toIndentedString(this.plaidAccountId)).append("\n");
        sb.append("    plaidProcessorToken: ").append(this.toIndentedString(this.plaidProcessorToken)).append("\n");
        sb.append("    plaidInstitutionId: ").append(this.toIndentedString(this.plaidInstitutionId)).append("\n");
        sb.append("    plaidAccountMask: ").append(this.toIndentedString(this.plaidAccountMask)).append("\n");
        sb.append("    plaidAccountName: ").append(this.toIndentedString(this.plaidAccountName)).append("\n");
        sb.append("    counterpartyGuid: ").append(this.toIndentedString(this.counterpartyGuid)).append("\n");
        sb.append("    counterpartyBankAccount: ").append(this.toIndentedString(this.counterpartyBankAccount)).append("\n");
        sb.append("    counterpartyName: ").append(this.toIndentedString(this.counterpartyName)).append("\n");
        sb.append("    counterpartyAddress: ").append(this.toIndentedString(this.counterpartyAddress)).append("\n");
        sb.append("    counterpartyEmailAddress: ").append(this.toIndentedString(this.counterpartyEmailAddress)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AccountKindEnum {
        PLAID("plaid"),
        PLAID_PROCESSOR_TOKEN("plaid_processor_token"),
        RAW_ROUTING_DETAILS("raw_routing_details");

        private String value;

        private AccountKindEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AccountKindEnum fromValue(String value) {
            for (AccountKindEnum b : AccountKindEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

