/*
 * Decompiled with CFR 0.152.
 */
package app.cybrid.cybrid_api_bank.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

@ApiModel(description="Request body for trade creation.")
@JsonPropertyOrder(value={"trade_type", "quote_guid", "fiat_account_guid", "expected_error", "labels"})
@JsonTypeName(value="PostTrade")
public class PostTradeBankModel {
    public static final String JSON_PROPERTY_TRADE_TYPE = "trade_type";
    private JsonNullable<TradeTypeEnum> tradeType = JsonNullable.of((Object)((Object)TradeTypeEnum.PLATFORM));
    public static final String JSON_PROPERTY_QUOTE_GUID = "quote_guid";
    private String quoteGuid;
    public static final String JSON_PROPERTY_FIAT_ACCOUNT_GUID = "fiat_account_guid";
    private JsonNullable<String> fiatAccountGuid = JsonNullable.undefined();
    public static final String JSON_PROPERTY_EXPECTED_ERROR = "expected_error";
    private JsonNullable<ExpectedErrorEnum> expectedError = JsonNullable.undefined();
    public static final String JSON_PROPERTY_LABELS = "labels";
    private JsonNullable<List<String>> labels = JsonNullable.undefined();

    public PostTradeBankModel tradeType(TradeTypeEnum tradeType) {
        this.tradeType = JsonNullable.of((Object)((Object)tradeType));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The type of trade.")
    @JsonIgnore
    public TradeTypeEnum getTradeType() {
        return (TradeTypeEnum)((Object)this.tradeType.orElse(null));
    }

    @JsonProperty(value="trade_type")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<TradeTypeEnum> getTradeType_JsonNullable() {
        return this.tradeType;
    }

    @JsonProperty(value="trade_type")
    public void setTradeType_JsonNullable(JsonNullable<TradeTypeEnum> tradeType) {
        this.tradeType = tradeType;
    }

    public void setTradeType(TradeTypeEnum tradeType) {
        this.tradeType = JsonNullable.of((Object)((Object)tradeType));
    }

    public PostTradeBankModel quoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="The associated quote's identifier.")
    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getQuoteGuid() {
        return this.quoteGuid;
    }

    @JsonProperty(value="quote_guid")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setQuoteGuid(String quoteGuid) {
        this.quoteGuid = quoteGuid;
    }

    public PostTradeBankModel fiatAccountGuid(String fiatAccountGuid) {
        this.fiatAccountGuid = JsonNullable.of((Object)fiatAccountGuid);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The identifier for the fiat account to use for the trade. Required if the customer or bank has multiple fiat accounts.")
    @JsonIgnore
    public String getFiatAccountGuid() {
        return (String)this.fiatAccountGuid.orElse(null);
    }

    @JsonProperty(value="fiat_account_guid")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<String> getFiatAccountGuid_JsonNullable() {
        return this.fiatAccountGuid;
    }

    @JsonProperty(value="fiat_account_guid")
    public void setFiatAccountGuid_JsonNullable(JsonNullable<String> fiatAccountGuid) {
        this.fiatAccountGuid = fiatAccountGuid;
    }

    public void setFiatAccountGuid(String fiatAccountGuid) {
        this.fiatAccountGuid = JsonNullable.of((Object)fiatAccountGuid);
    }

    public PostTradeBankModel expectedError(ExpectedErrorEnum expectedError) {
        this.expectedError = JsonNullable.of((Object)((Object)expectedError));
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The optional expected error to simulate trade failure.")
    @JsonIgnore
    public ExpectedErrorEnum getExpectedError() {
        return (ExpectedErrorEnum)((Object)this.expectedError.orElse(null));
    }

    @JsonProperty(value="expected_error")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<ExpectedErrorEnum> getExpectedError_JsonNullable() {
        return this.expectedError;
    }

    @JsonProperty(value="expected_error")
    public void setExpectedError_JsonNullable(JsonNullable<ExpectedErrorEnum> expectedError) {
        this.expectedError = expectedError;
    }

    public void setExpectedError(ExpectedErrorEnum expectedError) {
        this.expectedError = JsonNullable.of((Object)((Object)expectedError));
    }

    public PostTradeBankModel labels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
        return this;
    }

    public PostTradeBankModel addLabelsItem(String labelsItem) {
        if (this.labels == null || !this.labels.isPresent()) {
            this.labels = JsonNullable.of(new ArrayList());
        }
        try {
            ((List)this.labels.get()).add(labelsItem);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The labels associated with the trade.")
    @JsonIgnore
    public List<String> getLabels() {
        return (List)this.labels.orElse(null);
    }

    @JsonProperty(value="labels")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public JsonNullable<List<String>> getLabels_JsonNullable() {
        return this.labels;
    }

    @JsonProperty(value="labels")
    public void setLabels_JsonNullable(JsonNullable<List<String>> labels) {
        this.labels = labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = JsonNullable.of(labels);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PostTradeBankModel postTrade = (PostTradeBankModel)o;
        return PostTradeBankModel.equalsNullable(this.tradeType, postTrade.tradeType) && Objects.equals(this.quoteGuid, postTrade.quoteGuid) && PostTradeBankModel.equalsNullable(this.fiatAccountGuid, postTrade.fiatAccountGuid) && PostTradeBankModel.equalsNullable(this.expectedError, postTrade.expectedError) && PostTradeBankModel.equalsNullable(this.labels, postTrade.labels);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(PostTradeBankModel.hashCodeNullable(this.tradeType), this.quoteGuid, PostTradeBankModel.hashCodeNullable(this.fiatAccountGuid), PostTradeBankModel.hashCodeNullable(this.expectedError), PostTradeBankModel.hashCodeNullable(this.labels));
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PostTradeBankModel {\n");
        sb.append("    tradeType: ").append(this.toIndentedString(this.tradeType)).append("\n");
        sb.append("    quoteGuid: ").append(this.toIndentedString(this.quoteGuid)).append("\n");
        sb.append("    fiatAccountGuid: ").append(this.toIndentedString(this.fiatAccountGuid)).append("\n");
        sb.append("    expectedError: ").append(this.toIndentedString(this.expectedError)).append("\n");
        sb.append("    labels: ").append(this.toIndentedString(this.labels)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ExpectedErrorEnum {
        EXPIRED_QUOTE("expired_quote"),
        NON_SUFFICIENT_FUNDS("non_sufficient_funds");

        private String value;

        private ExpectedErrorEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static ExpectedErrorEnum fromValue(String value) {
            for (ExpectedErrorEnum b : ExpectedErrorEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static enum TradeTypeEnum {
        PLATFORM("platform"),
        EXIT("exit");

        private String value;

        private TradeTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TradeTypeEnum fromValue(String value) {
            for (TradeTypeEnum b : TradeTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }
}

