/*
 * Cybrid Bank API
 * # Welcome  Welcome to the Cybrid platform; enabling turnkey crypto banking services!  In these documents, you will find information on the operations provided by our platform, as well as details on how our REST API operates more generally.  Our complete set of APIs allows you to manage all your resources: your Organization, your banks and your identities. The complete set of APIs can be found on the following pages:  | API                                                            | Description                  | |----------------------------------------------------------------|------------------------------| | [Organization API](https://organization.demo.cybrid.app/api/schema/swagger-ui) | APIs to manage organizations | | [Bank API](https://bank.demo.cybrid.app/api/schema/swagger-ui)                 | APIs to manage banks         | | [Identities API](https://id.demo.cybrid.app/api/schema/swagger-ui)                     | APIs to manage identities    |  When you're ready, [request access](https://www.cybrid.xyz/access) to your Dashboard to view and administer your Organization. Once you've logged in, you can begin creating Banks, either for sandbox or production usage, and start enabling your customers to leverage DeFi and web3 with confidence.  If you have any questions, please contact [Support](mailto:support@cybrid.app) at any time so that we can help.  ## Authentication  The Cybrid Platform uses OAuth 2.0 Bearer Tokens to authenticate requests to the platform. Credentials to create Organization and Bank tokens can be generated via your Dashboard ([request access](https://www.cybrid.xyz/access)).  An Organization Token applies broadly to the whole Organization and all of its Banks, whereas, a Bank Token is specific to an individual Bank.  Both Organization and Bank tokens can be created using the OAuth Client Credential Grant flow. Each Organization and Bank has its own unique Client ID and Secret that allows for machine-to-machine authentication.  **Never share your Client ID or Secret publicly or in your source code repository**  Your Client ID and Secret can be exchanged for a time-limited Bearer Token by interacting with the Cybrid Identity Provider or through interacting with the **Authorize** button in this document:  ``` curl -X POST https://id.demo.cybrid.app/oauth/token -d '{     \"grant_type\": \"client_credentials\",     \"client_id\": \"<Your Client ID>\",     \"client_secret\": \"<Your Secret>\",     \"scope\": \"<Your requested scopes -- space separated>\"   }' -H \"Content-Type: application/json\" ```  ## Scopes  The Cybrid platform supports the use of scopes to control the level of access a token is limited to. Scopes do not grant access to resources; instead, they provide limits, in support of the least privilege principal.  The following scopes are available on the platform and can be requested when generating either an Organization or a Bank token. Generally speaking, the _Read_ scope is required to read and list resources, the _Write_ scope is required to update a resource and the _Execute_ scope is required to create a resource.  | Resource      | Read scope         | Write scope          | Execute scope     | Token Type         | |---------------|--------------------|----------------------|-------------------|--------------------| | Organizations | organizations:read | organizations:write  |                   | Organization/ Bank | | Banks         | banks:read         | banks:write          | banks:execute     | Organization/ Bank | | Customers     | customers:read     | customers:write      | customers:execute | Bank               | | Assets        | prices:read        |                      |                   | Bank               | | Accounts      | accounts:read      |                      | accounts:execute  | Bank               | | Prices        | prices:read        |                      |                   | Bank               | | Symbols       | prices:read        |                      |                   | Bank               | | Quotes        | quotes:read        |                      | quotes:execute    | Bank               | | Trades        | trades:read        |                      | trades:execute    | Bank               |  ## Organizations  An Organization is meant to model the organization partnering with Cybrid to use our platform.  An Organization does not directly interact with customers. Instead, an Organization has one or more banks, which encompass the financial service offerings of the platform.  ## Banks  A Bank is owned by an Organization and can be thought of as an environment or container for Customers and product offerings. An example of a Bank would be your customer facing banking website, or an internal staging environment for testing and integration.  An Organization can have multiple banks, in sandbox or production environments. A sandbox Bank will be backed by stubbed data and process flows. For instance, identity record and funding source processes will be simulated rather than performed.  ## Customers  Customers represent your banking users on the platform. At present, we offer support for Individuals as Customers.  Customers must be verified in our system before they can play any part on the platform. See the Identity Records section for more details on how a customer can be verified.  Customers must also have an account to be able to transact. See the Accounts APIs for more details on setting up accounts for the customer. 
 *
 * The version of the OpenAPI document: v0.30.17
 * Contact: support@cybrid.app
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package app.cybrid.cybrid_api_bank.client.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * ExchangeSettlementExpectedPaymentBankModel
 */
@JsonPropertyOrder({
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_GUID,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_SEQUENCE_NUMBER,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_PAYMENT_AMOUNT,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_INTERNAL_ACCOUNT_GUID,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_STATE,
  ExchangeSettlementExpectedPaymentBankModel.JSON_PROPERTY_CREATED_AT
})
@JsonTypeName("ExchangeSettlementExpectedPayment")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2022-06-24T11:03:33.345307Z[Etc/UTC]")
public class ExchangeSettlementExpectedPaymentBankModel {
  public static final String JSON_PROPERTY_GUID = "guid";
  private String guid;

  public static final String JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID = "exchange_settlement_obligation_guid";
  private String exchangeSettlementObligationGuid;

  public static final String JSON_PROPERTY_SEQUENCE_NUMBER = "sequence_number";
  private java.math.BigInteger sequenceNumber;

  public static final String JSON_PROPERTY_PAYMENT_AMOUNT = "payment_amount";
  private java.math.BigInteger paymentAmount;

  public static final String JSON_PROPERTY_INTERNAL_ACCOUNT_GUID = "internal_account_guid";
  private String internalAccountGuid;

  /**
   * The type of the internal account that is expected to originate the payment.
   */
  public enum InternalAccountTypeEnum {
    WALLET("internal_wallet"),
    
    BANK_ACCOUNT("internal_bank_account");

    private String value;

    InternalAccountTypeEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static InternalAccountTypeEnum fromValue(String value) {
      for (InternalAccountTypeEnum b : InternalAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE = "internal_account_type";
  private InternalAccountTypeEnum internalAccountType;

  /**
   * The exchange settlement expected payment&#39;s state
   */
  public enum StateEnum {
    STORING("storing"),
    
    PENDING__CREATED("pending__created"),
    
    PENDING__TRANSACTIONS_CLAIMED("pending__transactions_claimed"),
    
    NOT_APPROVED("not_approved"),
    
    IN_PROGRESS("in_progress"),
    
    NOT_OWED("not_owed"),
    
    AMOUNT_INCORRECT("amount_incorrect"),
    
    CANCELLED("cancelled"),
    
    RECEIVED("received");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_CREATED_AT = "created_at";
  private OffsetDateTime createdAt;

  public ExchangeSettlementExpectedPaymentBankModel() { 
  }

  public ExchangeSettlementExpectedPaymentBankModel guid(String guid) {
    
    this.guid = guid;
    return this;
  }

   /**
   * Auto-generated unique identifier for the exchange settlement expected payment.
   * @return guid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "Auto-generated unique identifier for the exchange settlement expected payment.")
  @JsonProperty(JSON_PROPERTY_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGuid() {
    return guid;
  }


  @JsonProperty(JSON_PROPERTY_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGuid(String guid) {
    this.guid = guid;
  }


  public ExchangeSettlementExpectedPaymentBankModel exchangeSettlementObligationGuid(String exchangeSettlementObligationGuid) {
    
    this.exchangeSettlementObligationGuid = exchangeSettlementObligationGuid;
    return this;
  }

   /**
   * The identifier of the exchange settlement obligation that this payment is associated with.
   * @return exchangeSettlementObligationGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the exchange settlement obligation that this payment is associated with.")
  @JsonProperty(JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getExchangeSettlementObligationGuid() {
    return exchangeSettlementObligationGuid;
  }


  @JsonProperty(JSON_PROPERTY_EXCHANGE_SETTLEMENT_OBLIGATION_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setExchangeSettlementObligationGuid(String exchangeSettlementObligationGuid) {
    this.exchangeSettlementObligationGuid = exchangeSettlementObligationGuid;
  }


  public ExchangeSettlementExpectedPaymentBankModel sequenceNumber(java.math.BigInteger sequenceNumber) {
    
    this.sequenceNumber = sequenceNumber;
    return this;
  }

   /**
   * The sequence number of the expected payment
   * @return sequenceNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The sequence number of the expected payment")
  @JsonProperty(JSON_PROPERTY_SEQUENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getSequenceNumber() {
    return sequenceNumber;
  }


  @JsonProperty(JSON_PROPERTY_SEQUENCE_NUMBER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSequenceNumber(java.math.BigInteger sequenceNumber) {
    this.sequenceNumber = sequenceNumber;
  }


  public ExchangeSettlementExpectedPaymentBankModel paymentAmount(java.math.BigInteger paymentAmount) {
    
    this.paymentAmount = paymentAmount;
    return this;
  }

   /**
   * The amount expected to be received as part of this payment.
   * @return paymentAmount
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The amount expected to be received as part of this payment.")
  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public java.math.BigInteger getPaymentAmount() {
    return paymentAmount;
  }


  @JsonProperty(JSON_PROPERTY_PAYMENT_AMOUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPaymentAmount(java.math.BigInteger paymentAmount) {
    this.paymentAmount = paymentAmount;
  }


  public ExchangeSettlementExpectedPaymentBankModel internalAccountGuid(String internalAccountGuid) {
    
    this.internalAccountGuid = internalAccountGuid;
    return this;
  }

   /**
   * The identifier of the internal account that is expected to originate the payment.
   * @return internalAccountGuid
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The identifier of the internal account that is expected to originate the payment.")
  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getInternalAccountGuid() {
    return internalAccountGuid;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_GUID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAccountGuid(String internalAccountGuid) {
    this.internalAccountGuid = internalAccountGuid;
  }


  public ExchangeSettlementExpectedPaymentBankModel internalAccountType(InternalAccountTypeEnum internalAccountType) {
    
    this.internalAccountType = internalAccountType;
    return this;
  }

   /**
   * The type of the internal account that is expected to originate the payment.
   * @return internalAccountType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The type of the internal account that is expected to originate the payment.")
  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public InternalAccountTypeEnum getInternalAccountType() {
    return internalAccountType;
  }


  @JsonProperty(JSON_PROPERTY_INTERNAL_ACCOUNT_TYPE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setInternalAccountType(InternalAccountTypeEnum internalAccountType) {
    this.internalAccountType = internalAccountType;
  }


  public ExchangeSettlementExpectedPaymentBankModel state(StateEnum state) {
    
    this.state = state;
    return this;
  }

   /**
   * The exchange settlement expected payment&#39;s state
   * @return state
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "The exchange settlement expected payment's state")
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }


  public ExchangeSettlementExpectedPaymentBankModel createdAt(OffsetDateTime createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * ISO8601 datetime the exchange settlement expected payment was created at.
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "ISO8601 datetime the exchange settlement expected payment was created at.")
  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }


  @JsonProperty(JSON_PROPERTY_CREATED_AT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ExchangeSettlementExpectedPaymentBankModel exchangeSettlementExpectedPayment = (ExchangeSettlementExpectedPaymentBankModel) o;
    return Objects.equals(this.guid, exchangeSettlementExpectedPayment.guid) &&
        Objects.equals(this.exchangeSettlementObligationGuid, exchangeSettlementExpectedPayment.exchangeSettlementObligationGuid) &&
        Objects.equals(this.sequenceNumber, exchangeSettlementExpectedPayment.sequenceNumber) &&
        Objects.equals(this.paymentAmount, exchangeSettlementExpectedPayment.paymentAmount) &&
        Objects.equals(this.internalAccountGuid, exchangeSettlementExpectedPayment.internalAccountGuid) &&
        Objects.equals(this.internalAccountType, exchangeSettlementExpectedPayment.internalAccountType) &&
        Objects.equals(this.state, exchangeSettlementExpectedPayment.state) &&
        Objects.equals(this.createdAt, exchangeSettlementExpectedPayment.createdAt);
  }

  @Override
  public int hashCode() {
    return Objects.hash(guid, exchangeSettlementObligationGuid, sequenceNumber, paymentAmount, internalAccountGuid, internalAccountType, state, createdAt);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ExchangeSettlementExpectedPaymentBankModel {\n");
    sb.append("    guid: ").append(toIndentedString(guid)).append("\n");
    sb.append("    exchangeSettlementObligationGuid: ").append(toIndentedString(exchangeSettlementObligationGuid)).append("\n");
    sb.append("    sequenceNumber: ").append(toIndentedString(sequenceNumber)).append("\n");
    sb.append("    paymentAmount: ").append(toIndentedString(paymentAmount)).append("\n");
    sb.append("    internalAccountGuid: ").append(toIndentedString(internalAccountGuid)).append("\n");
    sb.append("    internalAccountType: ").append(toIndentedString(internalAccountType)).append("\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

